let express = require('express')
let axios = require('axios')
let app = express()
let cors = require('cors')
const {
    extractAfterWord,
    parseNameSectionsFromLines
} = require('./functions');

app.use(cors())

app.get('/lines', (req, res) => {

    (async () => {
        try {
            // Step 1: Extract everything after the keyword
            const extractedLines = await extractAfterWord('list.txt', '#Name:');
            // Step 2: Parse those extracted lines
            const parsedData = await parseNameSectionsFromLines(extractedLines);
            // Step 3: Display result
            console.log(JSON.stringify(parsedData, null, 2));
            res.json(parsedData)
        } catch (error) {
            console.error('Error:', error);
        }
    })()

})

const port = process.env.PORT || 3000;
app.listen(port, () => {
    console.log(`Listening on ${port}`);
})