const fs = require('fs')
const readline = require('readline')

async function extractAfterWord(filePath, word) {
    const readStream = fs.createReadStream(filePath);
    const rl = readline.createInterface({
        input: readStream,
        crlfDelay: Infinity
    });

    const lines = [];
    for await (const line of rl) {
        const index = line.indexOf(word);
        if (index !== -1) {
            const after = line.slice(index).trim();
            if (after) lines.push(after);
        }
    }

    return lines;
}

async function parseNameSectionsFromLines(lines) {
    const result = {};
    let currentRoot = null;

    const rootPattern = /^#Name: #\s*(.*)$/;
    const itemPattern = /^#Name: (.+)$/;
    const adanaPattern = /^#Name\s*:\s*XX\s*:/;
    const k4Pattern = /^#Name: \|4K\|/;

    for (const line of lines) {
        const rootMatch = line.match(rootPattern);
        if (rootMatch) {
            currentRoot = rootMatch[1].replace(/#/g, '').trim();
            result[currentRoot] = [];
            continue;
        }

        if (adanaPattern.test(line)) {
            if (!result["ADULTS"]) result["ADULTS"] = [];
            const item = line.replace(adanaPattern, '').replace(/#/g, '').trim();
            if (item) result["ADULTS"].push(item);
            continue;
        }

        if (k4Pattern.test(line)) {
            if (!result["4K UHD"]) result["4K UHD"] = [];
            const item = line.replace(/^#Name:\s*\|4K\|/, '').replace(/#/g, '').trim();
            if (item) result["4K UHD"].push(item);
            continue;
        }

        const itemMatch = line.match(itemPattern);
        if (itemMatch && currentRoot) {
            const item = itemMatch[1].replace(/#/g, '').trim();
            if (item) result[currentRoot].push(item);
        }
    }

    return result;
}

// Export functions
module.exports = {
    extractAfterWord,
    parseNameSectionsFromLines
}