<?php $__env->startSection('title', config('app.name').' || Channels List'); ?>
<?php $__env->startSection('content'); ?>
<div class="container">
    <div id="channels_list">
        <h1>Channels List</h1>
        <p>At <?php echo e(config('app.name')); ?> we can offer you an access to up to 16,000 IPTV channels of all countries around the world, we want to make sure that you won't be disappointed.</p>
        <div class="row">
          <div class="col-md-3">
            <div class="box">
              <ul>
                <?php for($i=0;$i < count($list); $i++): ?>
                <li country-id="<?php echo e($list[$i]['id']); ?>" class="<?php echo e(($i == 0) ? 'active' : ''); ?>"><?php echo e($list[$i]['country']); ?></li>
                <?php endfor; ?>
              </ul>
            </div>
          </div>
          <div class="col-md-9">
            <div class="box">
              <div class="data">
                <?php echo $first_data; ?>

              </div>
            </div>
          </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_js'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/axios/1.2.1/axios.min.js" integrity="sha512-zJYu9ICC+mWF3+dJ4QC34N9RA0OVS1XtPbnf6oXlvGrLGNB8egsEzu/5wgG90I61hOOKvcywoLzwNmPqGAdATA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>
  $(document).ready(function() {
    $('div#channels_list .box ul li').on('click', function() {
      const isActive = $(this).hasClass('active')
      console.log(isActive)
      var myurl = '<?php echo e(route('getCountryData', 0)); ?>'
      const country_id = $(this).attr('country-id')
      if( !isActive ) {
        $(this).siblings().removeClass('active')
        $(this).addClass('active')
        axios.get( myurl.replace('/0', '/'+country_id).replace('http://', 'https://') ).then(data => {
          $(this).attr('fetched', true)
          $('div#channels_list .box .data').html(data.data)
          $('div#channels_list .box .data').scrollTop(0)
          $(this).attr('fetched', true)
        })
      }
    })
  })
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/x.ipsubtv.com/resources/views/channels_list.blade.php ENDPATH**/ ?>