<?php $__env->startSection('title', 'Testimonials'); ?>
<?php $__env->startSection('content'); ?>
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
  <a href="<?php echo e(route('admin.testimonial_insert')); ?>" class="goback btn btn-danger"><i class="fa fa-plus"></i>Insert Testimonial</a>
</div>
<div class="card card-default color-palette-box">
    <?php if( session()->has('success') ): ?>
    <span class="badge bg-success"> <?php echo e(session()->get('success')); ?> </span>
    <?php endif; ?>
    <div class="card-body">
       <?php if(count($testimonials) > 0): ?>
       <table class="table">
        <thead>
          <tr>
            <th scope="col"></th>
            <th scope="col"></th>
            <th scope="col">Name</th>
            <th scope="col">Country</th>
            <th scope="col">Visibility</th>
            <th scope="col">Creation Date</th>
            <th scope="col"></th>
          </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr class="product-table">
            <td><?php echo e($testimonial->id); ?></td>
            <td><img class="img-thumbnail" width="70px" src="<?php echo e(\Illuminate\Support\Str::contains($testimonial->poster, 'https://') ? $testimonial->poster : asset('storage/'.$testimonial->poster)); ?>"></td>
            <td class="title"><?php echo e($testimonial->name); ?></td>
            <td><?php echo e($testimonial->country); ?></td>
            <td>
              <span class="badge bg-<?php echo e($testimonial->visibility == '1' ? 'success' : 'warning'); ?>">
                <?php echo e($testimonial->visibility == '1' ? 'Visible' : 'Draft'); ?>

              </span>
            </td>
            <td><?php echo e($testimonial->created_at); ?></td>
            <td class="actions">
              <a href="<?php echo e(route('admin.testimonial_edit', $testimonial->id)); ?>"><i class="edit fa fa-pencil"></i></a>
              <a class="remove_prod" data-id="<?php echo e($testimonial->id); ?>" href="#"><i class="edit fa fa-trash"></i></a>
            </td>
          </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
       <?php else: ?>
       <h3>No Testimonials</h3>
       <?php endif; ?>
    </div>
 </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_js'); ?>
<script>
$(document).ready(() => {
    $(".card-body>.badge.bg-success").fadeTo(2000, 500).slideUp(500, function(){
        $(".card-body>.badge.bg-success").slideUp(500);
    });
    $('.remove_prod').on('click', function(e) {
        e.preventDefault()
        var confirmA = confirm('Delete This Testimonial ?')
        var testimonial_id = $(this).data('id')
        var link = "<?php echo e(route('admin.testimonial_delete', 5)); ?>"
        console.log(link)
        if(confirmA) {
        window.location.href = link.replace('/5', '/'+testimonial_id)
        }
    });
})
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_css'); ?>
    <style>
td.title {
  background: #eee;
  width: 100%;
  display: inline-block;
  color: #333;
  padding: 19px 20px;
}
span.badge.bg-success {
  padding: 4px 7px;
}
    </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.adminapp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/ipsubtv.com/resources/views/admin/testimonials.blade.php ENDPATH**/ ?>