<?php $__env->startSection('title', config('app.name').' || Cart'); ?>
<?php $__env->startSection('extra_css'); ?>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<style>
#shopping-cart .checkout a {
    background: #030e2e;
    padding: 13px 81px;
    font-size: 21px;
    font-weight: 600;
}
#shopping-cart .checkout a:hover {
    background: #010616;
    transition: 0.3s;
}

.select2-results__option--selectable {
    background: #eee;
    border-bottom: 2px solid #fff;
}

.select2-results__option--selectable:first-child {
    background: #fff;
    border-bottom: 2px solid #fff;
}

</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="container">
    <div id="shopping-cart">
        <?php if($items->count()>0): ?>
        <?php if(session()->has('success')): ?>
        <div class="alert alert-success" role="alert">
            <?php echo e(session()->get('success')); ?>

        </div>
        <?php endif; ?>
        <div class="row justify-content-center">
            <div class="col-md-7">
                <div class="items">
                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="cart-item">
                        <h2><?php echo e($item->model->period); ?></h2>
                        <ul>
                           <?php
                               $item_devices = \App\Models\Product::whereId($item->model->id)->first()->category->name;
                           ?>
                           <li style="text-transform:capitalize">* <?php echo e($item_devices); ?></li>
                           <li>* +16k TV Channels</li>
                           <li>* +60k VOD</li>
                           <li>* No activation fees</li>
                           <li>* Technical Assistance & support</li>
                           <li>* Compatible with all devices & apps</li>
                        </ul>
                     </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                 </div>
                 <div class="additional_info">
                    <h2>Configure</h2>
                    <div class="body">
                       <form id="checkout_bridge_form" action="<?php echo e(route('checkout_bridge')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="col-md-12 mt-4">
                                <label for="subtype_id" class="form-label">Subscription Type</label> 
                                <select name="subtype_id" class="subtypes" id="subtype_id" class="form-select">
                                    <option value="0" selected>- Select Subscription Type</option>
                                    <option v-for="subtype in subtypes" :value="subtype.id">{{subtype.title}}</option>
                                </select>
                            </div>
                            <div class="col-md-12 mt-4">
                                <label for="mac_address" class="form-label">
                                    Mac Address
                                    <small>Put Your Mac Address Only If You Use Mag Device (Please note that it should be starts with 00:1A)</small>
                                </label>
                                <input type="text" id="mac_address" name="mac_address" placeholder="00:1A:79:XX:XX:XX" class="form-control">
                            </div>
                            <div class="col-md-12 mt-4">
                                <label for="notes" class="form-label">
                                    Any Additional Info ?
                                </label>
                                <textarea name="notes" id="notes" cols="30" rows="10" class="form-control" placeholder="if you have order for many mag devices, please enter the other mac addresses here."></textarea>
                            </div>
                            <span
                                v-if="adult.enabled || vod.enabled"
                                class="addons_title">Addons <small>( Green background means that you are selected the addon )</small></span>
                            <div class="row">
                                <div class="col-md-6" v-if="adult.enabled">
                                    <div :class="{addon_item: true, addon_item_active: adult.status }" @click="adult.status = !adult.status">
                                        <input class="form-check-input" type="checkbox" v-model="adult.status" name="adult">
                                        <span>
                                            Adult Content
                                            <small v-if="adult.price == 0">FREE</small>
                                            <small v-else>{{adult.price}}$</small>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-md-6" v-if="vod.enabled">
                                    <div :class="{addon_item: true, addon_item_active: vod.status }" @click="vod.status = !vod.status">
                                        <input class="form-check-input" type="checkbox" v-model="vod.status" name="vod">
                                        <span>VOD ( Series & Movies )
                                            <small v-if="vod.price == 0">FREE</small>
                                            <small v-else>{{vod.price}}$</small>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-md-6" v-if="prioritize.enabled">
                                    <div :class="{addon_item: true, addon_item_active: prioritize.status }" @click="prioritize.status = !prioritize.status">
                                        <input class="form-check-input" type="checkbox" v-model="prioritize.status" name="prioritize">
                                        <span>Quick Delivery
                                            <small v-if="prioritize.price == 0">FREE</small>
                                            <small v-else>{{prioritize.price}}$</small>
                                        </span>
                                    </div>
                                </div>
                            </div>
                       </form>
                    </div>
                 </div>
            </div>
            <div class="col-md-3">
                <div class="summary">
                    <p class="order_summary">order summary</p>
                    <span class="subtotal">
                        subtotal
                        <p><?php echo e(Cart::subtotal()); ?>$</p>
                    </span>
                    <span class="subtotal" v-if="adult.status && adult.enabled">
                        Adult Content
                        <p>{{adult.price}} $</p>
                    </span>
                    <span class="subtotal" v-if="vod.status && vod.enabled">
                        VOD Content
                        <p>{{vod.price}} $</p>
                    </span>
                    <span class="subtotal" v-if="prioritize.status && prioritize.enabled">
                        Quick Delivery
                        <p>{{prioritize.price}} $</p>
                    </span>
                    <span class="subtotal">
                        Setup Fees
                        <p>0$</p>
                    </span>
                    <span class="total">
                        Total Due Today
                        <p>{{total}}$</p>
                        <button @click.prevent="checkout" href="#" class="btn btn-success"><i class="fa fa-credit-card"></i> Checkout</button>
                    </span>
                </div>
            </div>
        </div>
        <?php else: ?>
        <div class="cart-empty">
            <h1>Your Shopping Cart Is Empty !</h1>
            <a href="<?php echo e(route('home')); ?>">Continue Shopping</a>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_js'); ?>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(() => {
        $(".alert-success").fadeTo(2000, 500).slideUp(500, function(){
            $(".alert-success").slideUp(500);
        })
        $('.subtypes').select2({width: '100%', padding: '14px'})
    })
</script>
<?php if( env('APP_ENV') == 'local' ): ?>
<script src="<?php echo e(asset('js/vue.js')); ?>"></script>
<?php else: ?>
<script src="<?php echo e(asset('js/vue.min.js')); ?>"></script>
<?php endif; ?>

<script>
    new Vue({
        el: '#shopping-cart',
        data: {
            subtypes: <?php echo $subtypes; ?>,
            adult: {
                enabled: <?php echo e($adult_enabled); ?>,
                status: false,
                price: <?php echo e($adult_price); ?>

            },
            vod: {
                enabled: <?php echo e($vod_enabled); ?>,
                status: false,
                price: <?php echo e($vod_price); ?>

            },
            prioritize: {
                enabled: <?php echo e($prioritize_enabled); ?>,
                status: false,
                price: <?php echo e($prioritize_price); ?>

            },
            total: <?php echo e(\Cart::subtotal()); ?>

        },
        methods: {
            checkout() {
                const selected_subtype_id = document.querySelector('select#subtype_id').value                
                if( selected_subtype_id == 0 ) {
                    alert('select the subscription type please')
                    return;
                }else {
                    let selected_subtype_title = ''
                    this.subtypes.forEach(element => {
                        if(selected_subtype_id == element.id) {
                            selected_subtype_title = element.title
                        }
                    })
                    if( selected_subtype_title.toLowerCase().includes('mag') && document.getElementById('mac_address').value == '') {
                        alert('Mac Address is Required ')
                        return
                    }
                }
                document.getElementById('checkout_bridge_form').submit()
            }
        },
        watch: {
            'adult.status'(val) {
                if( val ) this.total += this.adult.price
                else this.total -= this.adult.price
            },
            'vod.status'(val) {
                if( val ) this.total += this.vod.price
                else this.total -= this.vod.price
            },
            'prioritize.status'(val) {
                if( val ) this.total += this.prioritize.price
                else this.total -= this.prioritize.price
            },
            total(number) {
                var num = Number(number)
                var roundedString = num.toFixed(2)
                var rounded = Number(roundedString)
                this.total = rounded
            }
        }
    })
</script>





<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/x.ipsubtv.com/resources/views/cart.blade.php ENDPATH**/ ?>