<?php $__env->startSection('title', config('app.name').' || CheckOut'); ?>
<?php $__env->startSection('content'); ?>
<div class="container">
    <div id="shopping-checkout">
        <h1>Checkout</h1>
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="customer-infos auth_container">
                    <div class="header">
                        <div>
                            <input type="radio" class="form-check-input" checked>
                            <span class="title">Your Info</span>
                        </div>
                    </div>
                    <div class="body">
                        </h2>
                        <form id="payform" method="POST" action="<?php echo e(route('payment.ok')); ?>">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="payment_method" id="payment_method" value="paypal">
                           <div class="row">
                                <div class="col-md-4 mb-2 form-group">
                                    <label for="billing_name">Name</label>
                                    <input type="text" class="form-control" id="billing_name" name="billing_name" placeholder="Put your name here" v-model="billing_name">
                                    <div v-if="billing_nameError" class="invalid-feedback">
                                        {{billing_nameError}}
                                    </div>
                                </div>
                                <div class="col-md-8 form-group">
                                    <label for="billing_email">email</label>
                                    <input type="text" class="form-control" id="billing_email" name="billing_email" placeholder="Put your email here" v-model="billing_email">
                                    <div v-if="billing_emailError" class="invalid-feedback">
                                        {{billing_emailError}}
                                    </div>
                                </div>
                                
                           </div>
                        </form>
                    </div>
                </div>
                <div class="customer-infos auth_container">
                    <div class="header">
                       <div>
                            <input type="radio" class="form-check-input" checked>
                            <span class="title">PayPal <small>( Credit / Debit Cards )</small>
                        </div>
                    </div>
                 </div>
            </div>
            <div class="col-md-4">
                <div class="customer-infos summary">
                    <div class="header">
                        <span class="title">Summary</span>
                    </div>
                    <div class="body summary">
                        <span class="subtotal">
                            <?php echo e($product_title); ?>

                            <p>{{sub_total}}$</p>
                        </span>
                        <span class="subtotal" v-if="adult_enabled">
                            Adult Content
                            <p>{{adult_price}}$</p>
                        </span>
                        <span class="subtotal" v-if="vod_enabled">
                            VOD Content
                            <p>{{vod_price}}$</p>
                        </span>
                        <span class="subtotal" v-if="prioritize_enabled">
                            Prioritize Order
                            <p>{{prioritize_price}}$</p>
                        </span>
                        <span class="subtotal">
                            Setup Fees
                            <p>0$</p>
                        </span>
                        <span class="total">
                            Total
                            <p>{{total}}$</p>
                        <button style="margin-top: 15px" @click.prevent="process_payment" href="#" class="btn btn-success"><i class="fa fa-credit-card-alt"></i> Complete Payment</button>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_js'); ?>
<?php if( env('APP_ENV') == 'local' ): ?>
<script src="<?php echo e(asset('js/vue.js')); ?>"></script>
<?php else: ?>
<script src="<?php echo e(asset('js/vue.min.js')); ?>"></script>
<?php endif; ?>
<script>
    new Vue({
        el: '#shopping-checkout',
        data: {

            adult_enabled: <?php echo e($adult); ?>,
            adult_price: <?php echo e($adult_price); ?>,

            vod_enabled: <?php echo e($vod); ?>,
            vod_price: <?php echo e($vod_price); ?>,

            prioritize_enabled: <?php echo e($prioritize); ?>,
            prioritize_price: <?php echo e($prioritize_price); ?>,

            sub_total: <?php echo e(Cart::subtotal()); ?>,

            billing_name: '',
            billing_email: '',
            billing_nameError: '',
            billing_emailError: ''

        },
        computed: {
            total() {
                const ttl = this.sub_total + this.adult_price + this.vod_price + this.prioritize_price
                var num = Number(ttl)
                var roundedString = num.toFixed(2)
                return Number(roundedString)
            }
        },
        methods: {
            process_payment() {
                if( this.billing_name == '' && this.billing_email == '' ) {
                    this.billing_nameError = 'Name Is Required'
                    this.billing_emailError = 'Email Is Required'
                }else if( this.billing_name == '' && !this.billing_email == '' ) {
                    this.billing_nameError = 'Name Field Is Required'
                }else if( !this.billing_name == '' && this.billing_email == '' ) {
                    this.billing_emailError = 'Email Field Is Required'
                }else if( !this.validateEmail(this.billing_email) ) {
                    this.billing_emailError = 'Please Enter A Valid Email Address'
                }else {
                    this.billing_nameError = ''
                    this.billing_emailError = ''
                    document.getElementById('payform').submit()
                }
            },
            validateEmail(email) {
                return email.match(
                    /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/
                )
            },
        }
    })
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_css'); ?>
<style>
ul.right-menu, .top-message, ul.top-menu, footer, .navbar a.order_now, .navbar a.cart_number, .navbar-toggler, .cta_btn a{
    display: none!important;
}

.top-right-menu ul li .dropdown {
    display: none;
}
#shopping-checkout .customer-infos .header .email {
    color: #c9bdbd;
    padding: 6px;
    display: block;
    text-transform: capitalize
}
#shopping-checkout .customer-infos.summary .header {
    text-align: center;
}

.form-control::placeholder {
    color: rgb(185, 185, 185)!important;
    opacity: 1;
    text-transform: capitalize
}

.form-control:-ms-input-placeholder {
    color: rgb(158, 158, 158)!important;
}

.form-control::-ms-input-placeholder {
    color: rgb(158, 158, 158)!important;
}

label {
    color: #bebebe;
    font-weight: 600;
    text-transform: capitalize;
    font-size: 15px;
    margin-block: 4px;
}

button.btn.btn-success {
    font-weight: 600;
    font-size: 15px;
    text-transform: uppercase;
}

</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/x.ipsubtv.com/resources/views/checkout.blade.php ENDPATH**/ ?>