<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" xmlns="http://www.w3.org/1999/xhtml" itemscope itemtype="http://schema.org/WebPage">
    <head prefix="og: http://ogp.me/ns# fb: http://ogp.me/ns/fb# article: http://ogp.me/ns/article#">
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=2">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <link rel="shortcut icon" href="<?php echo e(asset('storage/'.\App\Models\Config::whereName('favicon')->first()->value)); ?>">
    <meta name="robots" content="noodp, noydir" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link rel="canonical" href="<?php echo e(url()->full()); ?>" />
	<meta property="og:locale" content="en_US" />
	<meta property="og:type" content="website" />
	<meta property="og:title" content="IPsubTV || Best IPTV Provider In Canada and USA" />
	<meta property="og:description" content="<?php echo e(\App\Models\Config::whereName('seo_description')->first()->value); ?>" />
	<meta property="og:url" content="<?php echo e(url()->full()); ?>" />
	<meta property="og:site_name" content="IPsubTV - IP TV Canada & USA" />
	<meta property="article:modified_time" content="2023-04-01T13:31:25+00:00" />
	<meta property="og:image" content="<?php echo e(asset('storage/'.\App\Models\Config::whereName('white_logo')->first()->value)); ?>" />
    <meta name="description" content="<?php echo e(\App\Models\Config::whereName('seo_description')->first()->value); ?>">
    <?php if( env('APP_ENV') == 'local' ): ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/app.css').'?v='.time()); ?>">
    <?php else: ?>
    <style>
        <?php echo $__env->make('layouts.inc.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </style>
    <?php endif; ?>
    <?php echo $__env->yieldContent('extra_css'); ?>
    <title><?php echo $__env->yieldContent('title'); ?></title>
    <?php if( \App\Models\Config::whereName('gads_tracking_enabled')->first()->value == 1 ): ?>
    <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(\App\Models\Config::whereName('gads_tracking_tag')->first()->value); ?>"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());
        gtag('config', "<?php echo e(\App\Models\Config::whereName('gads_tracking_tag')->first()->value); ?>");
    </script>
    <?php endif; ?>
    </head>
    <body>
        <a id="whatsapp_button" href="<?php echo e(App\Models\Config::whereName('whatsapp_link')->first()->value); ?>" target="_blank"><i class="fa fa-whatsapp"></i><span> Chat With Us </span></a>
        <div id="header">
            <?php if( App\Models\Config::whereName('top_message_allowed')->first()->value == 1 ): ?>
            <div class="top-message animate__animated animate__fadeIn">
                <?php echo e(App\Models\Config::whereName('top_message')->first()->value); ?>

            </div>
            <?php endif; ?>
            <nav class="navbar navbar-expand-lg">
                <div class="container">
                    <a id="logo" class="nav-brand animate__animated animate__rubberBand" href="<?php echo e(route('home')); ?>">
                        <img width="118" height="48" alt="<?php echo e(config('app.name').' - '.\App\Models\Config::whereName('website_description')->first()->value); ?>" src="<?php echo e(asset('storage/'.\App\Models\Config::whereName('white_logo')->first()->value)); ?>">
                    </a>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"><i class="fa fa-bars" aria-hidden="true"></i></span>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav top-menu me-auto mb-2 mb-lg-0">
                            <li><a class="nav-item hvr-underline-from-center" target="_blank" href="<?php echo e(App\Models\Config::whereName('whatsapp_link')->first()->value); ?>">FREE TRIAL</a></li>
                            <li>
                                <a class="nav-item hvr-underline-from-center" href="<?php echo e(Route::currentRouteName() == 'home' ? '#subscribe' : route('subscriptions')); ?>">
                                    pricing
                                </a>
                            </li>
                            <li><a class="nav-item hvr-underline-from-center" href="<?php echo e(route('setup')); ?>">SETUP</a></li>
                            <li><a class="nav-item hvr-underline-from-center" href="<?php echo e(route('channels_list')); ?>">Channels List</a></li>
                            <li><a class="nav-item hvr-underline-from-center" href="<?php echo e(route('contactus')); ?>">Contact Us</a></li>
                        </ul>
                        <div class="top-right-menu">
                            <ul>
                                <li>
                                    <div class="cta_btn">
                                        <a class="order_now_cta" href="<?php echo e(Route::currentRouteName() == 'home' ? '#subscribe' : route('subscriptions')); ?>"> Order Now </a>
                                     </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </nav>
        </div>
        <?php echo $__env->yieldContent('content'); ?>
        <div id="whatsapp">
            <div class="container">
                <h1>Do You Have More Questions ?, DM US On WHATSAPP</h1>
                <a href="<?php echo e(App\Models\Config::whereName('whatsapp_link')->first()->value); ?>" target="_blank" class="btn_whatsapp animate__animated animate__fadeInUp"><i class="fa fa-whatsapp"></i> Reach Us On WHATSAPP</a>
            </div>
        </div>
        <?php if( \App\Models\Config::whereName('show_devices')->first()->value == 1): ?>
        <div id="devices_list">
            <h1>our iptv working on all devices and apps</h1>
            <ul class="devices col-md-11">
                <li class="item">
                    <img width="171" height="53" src="<?php echo e(asset('images/devices/webp/duplex.webp')); ?>" alt="duplex player iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="<?php echo e(asset('images/devices/webp/room_iptv.webp')); ?>" alt="room iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="<?php echo e(asset('images/devices/webp/ibo_player.webp')); ?>" alt="ibo player iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="<?php echo e(asset('images/devices/webp/smarters.webp')); ?>" alt="iptv smarters pro">
                </li>
                <li class="item">
                    <img width="171" height="53" src="<?php echo e(asset('images/devices/webp/gse_smart_iptv.webp')); ?>" alt="gse smart iptv app">
                </li>
                <li class="item">
                    <img width="171" height="53" src="<?php echo e(asset('images/devices/webp/smart_one.webp')); ?>" alt="smartone iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="<?php echo e(asset('images/devices/webp/net_iptv.webp')); ?>" alt="net iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="<?php echo e(asset('images/devices/webp/set_iptv.webp')); ?>" alt="set iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="<?php echo e(asset('images/devices/webp/IPTV_Extreme_Pro.webp')); ?>" alt="IPTV Extreme Pro iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="<?php echo e(asset('images/devices/webp/mi_box.webp')); ?>" alt="mi box iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="<?php echo e(asset('images/devices/webp/tivimate.webp')); ?>" alt="tivimate app iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="<?php echo e(asset('images/devices/webp/android_white.webp')); ?>" alt="android iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="<?php echo e(asset('images/devices/webp/dreambox_white.webp')); ?>" alt="dreambox iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="<?php echo e(asset('images/devices/webp/dreamlink_white.webp')); ?>" alt="dreamlink iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="<?php echo e(asset('images/devices/webp/enigma2_white.webp')); ?>" alt="enigma2 iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="<?php echo e(asset('images/devices/webp/firestick_white.webp')); ?>" alt="firestick iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="<?php echo e(asset('images/devices/webp/formuler_z8_white.webp')); ?>" alt="formuler z8 iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="<?php echo e(asset('images/devices/webp/mac_os_white.webp')); ?>" alt="mac os iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="<?php echo e(asset('images/devices/webp/magbox_white.webp')); ?>" alt="magbox iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="<?php echo e(asset('images/devices/webp/smart_stb_white.webp')); ?>" alt="smart stb iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="<?php echo e(asset('images/devices/webp/smart_tv_white.webp')); ?>" alt="smart tv iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="<?php echo e(asset('images/devices/webp/windows_white.webp')); ?>" alt="windows iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="<?php echo e(asset('images/devices/webp/smart_iptv_white.webp')); ?>" alt="smart iptv">
                </li>
            </ul>
        </div>
        <?php endif; ?>
        <footer>
            <div class="container">
                <div class="row top_s">
                    <div class="about_us col-md-6">
                        <img width="118" height="48" alt="<?php echo e(\App\Models\Config::whereName('about_us')->first()->value); ?>" 
                            src="<?php echo e(asset('storage/'.\App\Models\Config::whereName('white_logo')->first()->value)); ?>">
                        <p><?php echo e(\App\Models\Config::whereName('about_us')->first()->value); ?></p>
                    </div>
                    <div class="col-md-6">
                        <div class="links">
                            <a href="<?php echo e(route('setup')); ?>" class="hvr-underline-from-center">setup</a>
                            <?php $__currentLoopData = \App\Models\LegalPage::whereVisibility(1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('page', $page->slug)); ?>" class="hvr-underline-from-center"><?php echo e($page->title); ?></a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('contactus')); ?>" class="hvr-underline-from-center">contact us</a>
                        </div>
                    </div>
                </div>

                <div class="_footer">
                    All Rights Are Reserved To <strong><?php echo e(config('app.name')); ?></strong> <i class="fa fa-copyright" aria-hidden="true"></i> 2022
                </div>
            </div>
        </footer>
        <?php if( \App\Models\Config::whereName('gtag')->first()->value ): ?>
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(\App\Models\Config::whereName('gtag')->first()->value); ?>"></script>
        <script>
            window.dataLayer = window.dataLayer || [];

            function gtag() {
                dataLayer.push(arguments);
            }
            gtag('js', new Date());
            gtag('config', "<?php echo e(\App\Models\Config::whereName('gtag')->first()->value); ?>");
        </script>
        <?php endif; ?>
        
        <?php if( env('APP_ENV') == 'local' ): ?>
        <script src="<?php echo e(asset('js/app.js').'?v='.time()); ?>">
        <?php else: ?>
        <script>
            <?php echo $__env->make('layouts.inc.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </script>
        <?php endif; ?>

        <?php echo $__env->yieldContent('extra_js'); ?>

        <?php if( \App\Models\Config::whereName('live_chat_enabled')->first()->value == 1 ): ?>
        <!--Start of Tawk.to Script-->
        <script type="text/javascript">
        var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
        (function(){
        var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
        s1.async=true;
        s1.src='https://embed.tawk.to/643363b031ebfa0fe7f76073/1gtkbqqra';
        s1.charset='UTF-8';
        s1.setAttribute('crossorigin','*');
        s0.parentNode.insertBefore(s1,s0);
        })();
        </script>
        <!--End of Tawk.to Script-->
        <?php endif; ?>

    </body>
</html><?php /**PATH /var/www/ipsubtv.com/resources/views/layouts/app.blade.php ENDPATH**/ ?>