<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\CartController;
use App\Http\Controllers\CheckoutController;
use App\Http\Controllers\HomeController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

/**
 * CUSTOMER AREA
*/

Route::get('/getCountryData/{id}', [ HomeController::class, 'getCountryData' ])->name('getCountryData');

Auth::routes([ 'register' => false, 'login' => false, 'reset' => false ]);
Route::get('/amlog', [ LoginController::class, 'showLoginForm' ]);
Route::post('/amlog', [ LoginController::class, 'login' ])->name('login');

Route::get('/allowed', function() {
    $domains = [
	'tvhost.io',
	'iptv.test',
	'ca-iptv.com',
	'iptvireland.tv'
    ];
    return response()->json($domains)->header('Access-Control-Allow-Origin', '*');
})->withoutMiddleware(VerifyCsrfToken::class);

// Route::get('/sitemap.xml', [ SitemapController::class, 'products' ])->name('sitemap');

Route::get('/', [ HomeController::class, 'home' ])->name('home');
// Route::get('/product/{slug}', [ HomeController::class, 'product' ])->name('product');
Route::get('/category/{id}', [ HomeController::class, 'category' ])->name('category');

Route::get('/cart', [ CartController::class, 'show' ])->name('cart');
Route::post('/cart', [ CartController::class, 'store' ])->name('cart.store');
Route::get('/cart/{rowId}', [ CartController::class, 'remove' ])->name('cart.remove');
Route::post('/update_qty', [ CartController::class, 'update_qty' ])->name('cart.update_qty');

Route::get('/checkout', [ CheckoutController::class, 'show' ])->name('checkout');
Route::post('/checkout_bridge', [ CheckoutController::class, 'checkout_bridge' ])->name('checkout_bridge');
Route::get('/complete_ref_payment/{id}', [ CheckoutController::class, 'complete_ref_payment' ])->name('complete_ref_payment');
Route::post('/payment/ok', [ CheckoutController::class, 'payment_ok' ])->name('payment.ok');
Route::get('/order_received', [ CheckoutController::class, 'order_received' ])->name('order_received');

Route::get('/contact-us', [ HomeController::class, 'contactus' ])->name('contactus');
Route::post('/contact-us', [ HomeController::class, 'contactus_send' ])->name('contactus.send');

Route::get('/channels-list', [ HomeController::class, 'channels_list' ])->name('channels_list');

Route::get('/subscriptions', [ HomeController::class, 'subscriptions' ])->name('subscriptions');

Route::get('/setup', [HomeController::class, 'setup'])->name('setup');
Route::get('/post/{slug}', [HomeController::class, 'post'])->name('post');

Route::get('/p/{slug}', [HomeController::class, 'page'])->name('page');

Route::get('pay_invoice/{data}', [CheckoutController::class, 'pay_invoice'])->name('pay_invoice');

Route::group(['namespace' => 'Admin', 'prefix' => 'admin', 'middleware' => ['auth', 'admin']], function() {
    Route::get('dashboard', [AdminController::class, 'dashboard'])->name('admin.dashboard');
    Route::get('orders', [AdminController::class, 'orders'])->name('admin.orders');
    Route::get('invoices', [AdminController::class, 'invoices'])->name('admin.invoices');
    Route::get('invoice/{id}', [AdminController::class, 'invoice'])->name('admin.invoice');
    Route::get('invoice_delete/{id}', [AdminController::class, 'invoice_delete'])->name('admin.invoice_delete');
    Route::post('send_invoice_link', [AdminController::class, 'send_invoice_link'])->name('admin.send_invoice_link');
    
    Route::get('order_delete/{id}', [AdminController::class, 'order_delete'])->name('admin.order_delete');
    Route::get('order/{id}', [AdminController::class, 'order'])->name('admin.order');
    Route::post('send_order', [AdminController::class, 'send_order'])->name('admin.send_order');
    Route::post('order', [AdminController::class, 'order_update_service'])->name('admin.order_update_service');
    Route::get('sent/{id}', [AdminController::class, 'set_sent'])->name('admin.set_sent');
    Route::get('refunded/{id}', [AdminController::class, 'set_refunded'])->name('admin.set_refunded');
    Route::get('paid/{id}', [AdminController::class, 'set_paid'])->name('admin.set_paid');
    /**
     * SETTINGS
    */
    Route::get('settings', [AdminController::class, 'settings'])->name('admin.settings');
    Route::post('/settings_save', [AdminController::class, 'settings_save'])->name('settings.save');
    /**
     * PRODUCTS
    */
    Route::get('products', [AdminController::class, 'products'])->name('admin.products');
    Route::get('product/{id}', [AdminController::class, 'product_edit'])->name('admin.product_edit');
    Route::post('product', [AdminController::class, 'product_update'])->name('admin.product_update');
    Route::get('product_insert', [AdminController::class, 'product_insert'])->name('admin.product_insert');
    Route::post('product_save', [AdminController::class, 'product_save'])->name('admin.product_save');
    Route::get('product_delete/{id}', [AdminController::class, 'product_delete'])->name('admin.product_delete');
    /**
     * TESTIMONIALS
    */
    Route::get('testimonials', [AdminController::class, 'testimonials'])->name('admin.testimonials');
    Route::get('testimonial_insert', [AdminController::class, 'testimonial_insert'])->name('admin.testimonial_insert');
    Route::get('testimonial_delete/{id}', [AdminController::class, 'testimonial_delete'])->name('admin.testimonial_delete');
    Route::post('testimonials', [AdminController::class, 'testimonial_save'])->name('admin.testimonial_save');
    Route::get('testimonial/{id}', [AdminController::class, 'testimonial_edit'])->name('admin.testimonial_edit');
    Route::post('testimonial', [AdminController::class, 'testimonial_update'])->name('admin.testimonial_update');

    /**
     * CATEGORIES
    */
    Route::get('categories', [AdminController::class, 'categories'])->name('admin.categories');
    Route::post('categories', [AdminController::class, 'categories_update'])->name('admin.categories_update');
    Route::get('category_insert', [AdminController::class, 'category_insert'])->name('admin.category_insert');
    Route::post('category_save', [AdminController::class, 'category_save'])->name('admin.category_save');
    Route::get('category_delete/{id}', [AdminController::class, 'category_delete'])->name('admin.category_delete');
    /**
     * FAQ
    */
    Route::get('questions', [AdminController::class, 'questions'])->name('admin.questions');
    Route::get('questions_insert', [AdminController::class, 'questions_insert'])->name('admin.questions_insert');
    Route::post('questions_save', [AdminController::class, 'questions_save'])->name('admin.questions_save');
    Route::get('questions_edit/{id}', [AdminController::class, 'questions_edit'])->name('admin.questions_edit');
    Route::post('questions_update', [AdminController::class, 'questions_update'])->name('admin.questions_update');
    Route::get('questions_delete/{id}', [AdminController::class, 'questions_delete'])->name('admin.questions_delete');
    /**
     * POSTS
    */
    Route::get('posts', [AdminController::class, 'posts'])->name('admin.posts');
    Route::get('post_insert', [AdminController::class, 'post_insert'])->name('admin.post_insert');
    Route::post('post_save', [AdminController::class, 'post_save'])->name('admin.post_save');
    Route::get('post_delete/{id}', [AdminController::class, 'post_delete'])->name('admin.post_delete');
    Route::get('post_edit/{id}', [AdminController::class, 'post_edit'])->name('admin.post_edit');
    Route::post('post_update', [AdminController::class, 'post_update'])->name('admin.post_update');
    /**
     * Legal Pages.
    */
    Route::get('legal_pages', [AdminController::class, 'legal_pages'])->name('admin.legal_pages');
    Route::get('legal_pages_insert', [AdminController::class, 'legal_pages_insert'])->name('admin.legal_pages_insert');
    Route::post('legal_pages_save', [AdminController::class, 'legal_pages_save'])->name('admin.legal_pages_save');
    Route::get('legal_pages_delete/{slug}', [AdminController::class, 'legal_pages_delete'])->name('admin.legal_pages_delete');
    Route::get('legal_pages_edit/{id}', [AdminController::class, 'legal_pages_edit'])->name('admin.legal_pages_edit');
    Route::post('legal_pages_update', [AdminController::class, 'legal_pages_update'])->name('admin.legal_pages_update');
});
