@extends('layouts.app')
@section('title', $title)
@section('content')


@if( $categories->count() > 1)
<div id="subscribe">
    <h2>Get the Best IPTV Subscription In Canada & USA</h2>
    <p>Looking for reliable and affordable IPTV subscription plans? Look no further! Our website offers a wide range of IPTV plans with same features and different prices to suit your needs. Whether you're a sports enthusiast or a movie buff, we have the perfect plan for you. <br>
        Plus, with our competitive pricing, you can enjoy the best IPTV services without breaking the bank. Try us out today and see for yourself!</p>
    <div class="container">
        <nav>
            <div class="nav nav-tabs" id="nav-tab" role="tablist">
               @foreach ($categories as $category)
               <button class="nav-link {{$category->id == $categories[0]->id ? 'active' : '' }}" id="{{$category->id}}-tab" data-bs-toggle="tab" data-bs-target="#nav-{{$category->id}}" type="button" role="tab" aria-controls="nav-{{$category->id}}" aria-selected="true">{{$category->name}}</button>
               @endforeach
            </div>
         </nav>
         <p class="note">
            * if you wanna watch on multiple devices in the same time, choose the number of devices do you have.
         </p>
         <p class="note">
            * You will get separated accounts, each device with its connection details.
         </p>
         <div class="tab-content" id="nav-tabContent">
           @foreach ($categories as $category)
           <div class="tab-pane {{ $categories[0]->id == $category->id ? 'show active' : '' }}" id="nav-{{$category->id}}" role="tabpanel" aria-labelledby="nav-one-tab">
               <div class="row d-flex justify-content-center text-center">
                  @foreach ($category->products()->where('visibility', 1)->get() as $product)
                  <div class="col-lg-3 col-md-4 col-sm-6">
                     <div class="product-item {{$product->hot == 1 ? 'product_hot' : ''}} animate__animated animate__fadeIn">
                        @if($product->hot == 1)<span class="hot">POPULAR</span>@endif
                        <h2 class="period">{{$product->period}}</h2>
                        <div class="product_price">
                           <span class="price">{{$product->price}}</span>
                           <span class="currency">USD</span>
                           <span class="old_price">{{$product->old_price}} $</span>
                        </div>
                        <ul class="server_infos">
                           <li class="conn_number"><i class="fa fa-check-circle-o"></i>{{$category->name}}</li>
                           @if( $product->monthly )
                           <li><i class="fa fa-check"></i>Only <span class="monthly">{{ $product->monthly }}</span> Monthly</li>
                           @else
                           <li><i class="fa fa-check"></i>No Activation Fees</li>
                           @endif
                           <li><i class="fa fa-check"></i>+16k Channels</li>
                           <li><i class="fa fa-check"></i>+67k Movies & Series</li>
                           <li><i class="fa fa-check"></i>CATCH UP | EPG</li>
                           <li><i class="fa fa-check"></i>8k, 4K, Ultra HD and HQ</li>
                           <li><i class="fa fa-check"></i>Anti Freeze System</li>
                           <li><i class="fa fa-check"></i>Support MAG</li>
                           <li><i class="fa fa-check"></i>Free Support 24/7</li>
                        </ul>
                        @if( $product->in_stock == 1 )
                        <form action="{{route('cart.store')}}" method="POST">
                           @csrf
                           <input type="hidden" name="id" value="{{$product->id}}">
                           <button type="submit" class="order_now_product" href="#">Order Now</button>
                        </form>
                        @else
                        <button type="submit" class="order_now_product btn" disabled href="#">Not Available</button>
                        @endif
                     </div>
                  </div>
                  @endforeach
               </div>
            </div>
           @endforeach
        </div>
        <div class="more_than4">
            <h2>You want more than 4 connections ?</h2>
            <p>Reach US On WhatsApp</p>
            <a class="reach_us" target="_blank" href="{{App\Models\Config::whereName('whatsapp_link')->first()->value.'?text=Hi, I am interesting in more than 4 connections plans'}}">
                <i class="fa fa-whatsapp"></i>
                Send WhatsApp MESSAGE
            </a>
        </div>
    </div>
</div>
@endif




@endsection
@section('extra_css')
<style>
    div#category {
        padding: 39px 0;
    }

    div#category>h1 {
        font-size: 33px;
        font-weight: 800;
        color: #f5f5f5;
        text-align: center;
        margin: 0;
        padding-bottom: 90px;
        padding-top: 12px;
    }
</style>
@endsection
@section('extra_js')
<script>
    jQuery(document).ready(function() {
        $('.order_now_product').on('click', function(e) {
            e.preventDefault()
            $(this).parent().submit();
        });
    })
</script>
@endsection