@extends('layouts.app')
@section('title', config('app.name').' - SETUP')
@section('content')
<div class="container">
    <div id="blog">
        <h1><i class="fa fa-bolt"></i> SETUP <i class="fa fa-bolt"></i></h1>
        <div class="blog">
            <div class="row d-flex justify-content-center text-center">
                @foreach ($posts as $post)
                <div class="col-md-4 col-lg-3 post-item animate__animated animate__fadeIn">
                    <a class="poster" href="{{route('post', $post->slug)}}"><img alt="{{$post->title}}" title="{{$post->title}}" class="image-responsive"
                        src="{{asset('storage/'.$post->poster)}}"></a>
                    <a class="title" title="{{$post->title}}" href="{{route('post', $post->slug)}}"><h1>{{$post->title}}</h1></a>
                    <span class="read_now"><a href="{{route('post', $post->slug)}}">Read Now</a></span>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
@endsection
@section('extra_css')
<style>
div#category {
    padding: 39px 0;
}
div#category>h1 {
    font-size: 33px;
    font-weight: 800;
    color: #333;
    text-align: center;
    margin: 0;
    padding-bottom: 23px;
    padding-top: 9px;
}
</style>
@endsection
