@extends('layouts.app')
@section('title', 'Profile')
@section('content')
<div class="container">
    <div id="client_area">
        <h1>Profile</h1>
        <div id="content">
            @if (session('success'))
            <div class="alert text-center alert-success mb-4" role="alert">
                {{ session('success') }}
            </div>
             @endif
            <form action="{{route('profile')}}" method="POST">
                @csrf
                <div class="row mb-3">
                    <label for="name" class="mb-1">Name</label>
                    <input class="form-control" type="text" name="name" id="name" placeholder="Name" value="{{$user->name}}">
                    @error('name')
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>                        
                    @enderror
                </div>
                <div class="row mb-3">
                    <label for="email" class="mb-1">Email</label>
                    <input class="form-control" type="text" name="email" id="email" placeholder="Email" value="{{$user->email}}" disabled>
                </div>
                <div class="row mb-3">
                    <label for="password" class="mb-1">Password</label>
                    <input class="form-control" type="password" name="password" id="password" placeholder="Password">
                </div>
                <div class="row mt-4">
                    <button class="btn btn-primary">update</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection