{{-- @extends('layouts.app')
@section('title', 'UrKey || '.$product->title)
@section('content')
<div class="container">
    <div id="product">
        @if(session()->has('error'))
        <div class="alert alert-danger" role="alert">
            {{session()->get('error')}}
        </div>
        @endif
        <div class="row">
            <div class="poster col-md-5">
                <img src="{{$product->poster}}" alt="{{$product->title}}" title="{{$product->title}}">
            </div>
            <div class="col-md-6">
                @auth
                <a href="{{route('admin.product_edit', $product->id)}}"><i class="fa fa-pencil"></i></a>
                @endauth
                <form id="prodform" method="post" action="{{route('cart.store')}}">
                    @csrf
                    <h1 title="{{$product->title}}" class="title">{{$product->title}}</h1>
                    <input name="id" type="hidden" value="{{$product->id}}" />
                    <input type="hidden" name="title" value="{{$product->title}}" />
                    <input type="hidden" name="slug" value="{{$product->slug}}" />
                    <span class="price">{{$product->price}}$</span>
                    <div class="input-group mb-3 choose_devic">
                        <span class="input-group-text" id="basic-addon2">Choose Your Device</span>
                        <select class="form-select" name="device" id="select_device">
                            <option value="0">Devices List</option>
                            @foreach ($devices as $device)
                            <option value="{{$device->name}}">{{$device->name}}</option>
                            @endforeach
                        </select>
                      </div>
                    <button type="submit" class="order_btn animate__animated animate__pulse col-md-7">order now</button>
                </form>
                <ul class="box-under">
                    <li>
                        <i class="fa fa-lock"></i>
                        <p>Secure Payment</p>
                    </li>
                    <li>
                        <i class="fa fa-modx"></i>
                        <p>100% Guaranteed</p>
                    </li>
                    <li>
                        <i class="fa fa-medium"></i>
                        <p>100% Working</p>
                    </li>
                </ul>
            </div>
        </div>
    </div>
    <div id="description">
            {!!$product->description!!}
        </div>
        @if (count($related_products) > 0)
        <div class="related_products">
            <h1 class="related_title">⭐ Related Products ⭐</h1>
            <div class="row d-flex justify-content-center text-center">
                @foreach ($related_products as $related_product)
                <div class="col-md-4 col-lg-3 product-item animate__animated animate__fadeIn">
                    <a class="poster" href="{{route('product', $related_product->slug)}}">
                        <img alt="{{$related_product->title}}" title="{{$related_product->title}}" class="image-responsive" src="{{ $related_product->poster ? $related_product->poster : asset('storage/'.$related_product->poster)}}"></a>
                    <a title="{{$related_product->title}}" class="title" href="{{route('product', $related_product->slug)}}">
                        <h1>{{$related_product->title}}</h1>
                    </a>
                    @if($related_product->hot == 1)<span class="hot">HOT</span>@endif
                    <span class="old_price">{{$related_product->old_price}}$</span>
                    <span class="price">{{$related_product->price}}$</span>
                </div>
                @endforeach
            </div>
        </div>
        @endif
    </div>
</div>
@endsection
@section('extra_js')
<script>
    $(document).ready(() => {
        $('.order_btn').on('click', function(e) {
            e.preventDefault();
            if($('select#select_device').val() !== '0') $('#prodform').submit()
            else alert('Please Choose Your Device')
        })
        $(".alert-danger").fadeTo(2000, 1000).slideUp(1000, function(){
            $(".alert-danger").slideUp(1000);
        });
    })
</script>
@endsection --}}