@extends('layouts.app')
@section('title', 'Order Received')
@section('content')
<div class="container">
   <div id="thank-you">
      <span>Order Received</span>
      <p>Thanks you, You order has been received. <br/> ( We will email you with all subscription details within some hours )</p>
      <div id="body">
         <div class="order_item">
            <span class="title">number</span>
            <p class="value">#{{$order->id}}</p>
         </div>
         <div class="order_item">
            <span class="title">payment Method</span>
            <p class="value">{{$order->payment_method == "cc" ? "Credit / Debit Cards" : "PayPal"}}</p>
         </div>
         <div class="order_item">
            <span class="title">service</span>
            <p class="value">{{$order->service->title}}</p>
         </div>
         <div class="order_item">
            <span class="title">email</span>
            <p class="value">{{$order->billing_email}}</p>
         </div>
         <div class="order_item">
            <span class="title">total</span>
            <p class="value">{{$order->total}} $</p>
         </div>
      </div>
      <a href="{{route('home')}}" class="homepage">homepage</a>
   </div>
</div>
@endsection
@section('extra_css')
<style>
</style>
@endsection
@section('extra_js')
@if ( \App\Models\Config::whereName('gads_tracking_enabled')->first()->value == 1)
<script>
   gtag('event', 'conversion', {
       'send_to': '{{\App\Models\Config::whereName("gads_conversion_id")->first()->value }}',
       'value': {{$order->total}},
       'currency': 'USD',
       'transaction_id': '{{$order->ppl_transaction_id}}'
   });
 </script>
@endif

@endsection