<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" xmlns="http://www.w3.org/1999/xhtml" itemscope itemtype="http://schema.org/WebPage">
    <head prefix="og: http://ogp.me/ns# fb: http://ogp.me/ns/fb# article: http://ogp.me/ns/article#">
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=2">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <link rel="shortcut icon" href="{{asset('storage/'.\App\Models\Config::whereName('favicon')->first()->value)}}">
    <meta name="robots" content="noodp, noydir, nofollow" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link rel="canonical" href="{{url()->full()}}" />
	<meta property="og:locale" content="en_US" />
	<meta property="og:type" content="website" />
	<meta property="og:title" content="IPsubTV || Best IPTV Provider In Canada and USA" />
	<meta property="og:description" content="{{\App\Models\Config::whereName('seo_description')->first()->value}}" />
	<meta property="og:url" content="{{url()->full()}}" />
	<meta property="og:site_name" content="IPsubTV - IP TV Canada & USA" />
	<meta property="article:modified_time" content="2023-04-01T13:31:25+00:00" />
	<meta property="og:image" content="{{asset('storage/'.\App\Models\Config::whereName('white_logo')->first()->value)}}" />
    <meta name="description" content="{{\App\Models\Config::whereName('seo_description')->first()->value}}">
    @if( env('APP_ENV') == 'local' )
    <link rel="stylesheet" href="{{asset('css/app.css').'?v='.time()}}">
    @else
    <style>
        @include('layouts.inc.css')
    </style>
    @endif
    @yield('extra_css')
    <title>@yield('title')</title>
    @if ( \App\Models\Config::whereName('gads_tracking_enabled')->first()->value == 1 )
    <script async src="https://www.googletagmanager.com/gtag/js?id={{\App\Models\Config::whereName('gads_tracking_tag')->first()->value}}"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());
        gtag('config', "{{\App\Models\Config::whereName('gads_tracking_tag')->first()->value}}");
    </script>
    @endif
    </head>
    <body>
        <a id="whatsapp_button" href="{{App\Models\Config::whereName('whatsapp_link')->first()->value}}" target="_blank"><i class="fa fa-whatsapp"></i><span> Chat With Us </span></a>
        <div id="header">
            @if( App\Models\Config::whereName('top_message_allowed')->first()->value == 1 )
            <div class="top-message animate__animated animate__fadeIn">
                {{App\Models\Config::whereName('top_message')->first()->value}}
            </div>
            @endif
            <nav class="navbar navbar-expand-lg">
                <div class="container">
                    <a id="logo" class="nav-brand animate__animated animate__rubberBand" href="{{route('home')}}">
                        <img width="118" height="48" alt="{{config('app.name').' - '.\App\Models\Config::whereName('website_description')->first()->value}}" src="{{asset('storage/'.\App\Models\Config::whereName('white_logo')->first()->value)}}">
                    </a>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"><i class="fa fa-bars" aria-hidden="true"></i></span>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav top-menu me-auto mb-2 mb-lg-0">
                            <li><a class="nav-item hvr-underline-from-center" target="_blank" href="{{App\Models\Config::whereName('whatsapp_link')->first()->value}}">FREE TRIAL</a></li>
                            <li>
                                <a class="nav-item hvr-underline-from-center" href="{{Route::currentRouteName() == 'home' ? '#subscribe' : route('subscriptions')}}">
                                    pricing
                                </a>
                            </li>
                            <li><a class="nav-item hvr-underline-from-center" href="{{route('setup')}}">SETUP</a></li>
                            <li><a class="nav-item hvr-underline-from-center" href="{{route('channels_list')}}">Channels List</a></li>
                            <li><a class="nav-item hvr-underline-from-center" href="{{route('contactus')}}">Contact Us</a></li>
                        </ul>
                        <div class="top-right-menu">
                            <ul>
                                <li>
                                    <div class="cta_btn">
                                        <a class="order_now_cta" href="{{Route::currentRouteName() == 'home' ? '#subscribe' : route('subscriptions')}}"> Order Now </a>
                                     </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </nav>
        </div>
        @yield('content')
        <div id="whatsapp">
            <div class="container">
                <h1>Do You Have More Questions ?, DM US On WHATSAPP</h1>
                <a href="{{App\Models\Config::whereName('whatsapp_link')->first()->value}}" target="_blank" class="btn_whatsapp animate__animated animate__fadeInUp"><i class="fa fa-whatsapp"></i> Reach Us On WHATSAPP</a>
            </div>
        </div>
        @if ( \App\Models\Config::whereName('show_devices')->first()->value == 1)
        <div id="devices_list">
            <h1>our iptv working on all devices and apps</h1>
            <ul class="devices col-md-11">
                <li class="item">
                    <img width="171" height="53" src="{{asset('images/devices/webp/duplex.webp')}}" alt="duplex player iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="{{asset('images/devices/webp/room_iptv.webp')}}" alt="room iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="{{asset('images/devices/webp/ibo_player.webp')}}" alt="ibo player iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="{{asset('images/devices/webp/smarters.webp')}}" alt="iptv smarters pro">
                </li>
                <li class="item">
                    <img width="171" height="53" src="{{asset('images/devices/webp/gse_smart_iptv.webp')}}" alt="gse smart iptv app">
                </li>
                <li class="item">
                    <img width="171" height="53" src="{{asset('images/devices/webp/smart_one.webp')}}" alt="smartone iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="{{asset('images/devices/webp/net_iptv.webp')}}" alt="net iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="{{asset('images/devices/webp/set_iptv.webp')}}" alt="set iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="{{asset('images/devices/webp/IPTV_Extreme_Pro.webp')}}" alt="IPTV Extreme Pro iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="{{asset('images/devices/webp/mi_box.webp')}}" alt="mi box iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="{{asset('images/devices/webp/tivimate.webp')}}" alt="tivimate app iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="{{asset('images/devices/webp/android_white.webp')}}" alt="android iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="{{asset('images/devices/webp/dreambox_white.webp')}}" alt="dreambox iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="{{asset('images/devices/webp/dreamlink_white.webp')}}" alt="dreamlink iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="{{asset('images/devices/webp/enigma2_white.webp')}}" alt="enigma2 iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="{{asset('images/devices/webp/firestick_white.webp')}}" alt="firestick iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="{{asset('images/devices/webp/formuler_z8_white.webp')}}" alt="formuler z8 iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="{{asset('images/devices/webp/mac_os_white.webp')}}" alt="mac os iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="{{asset('images/devices/webp/magbox_white.webp')}}" alt="magbox iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="{{asset('images/devices/webp/smart_stb_white.webp')}}" alt="smart stb iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="{{asset('images/devices/webp/smart_tv_white.webp')}}" alt="smart tv iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="{{asset('images/devices/webp/windows_white.webp')}}" alt="windows iptv">
                </li>
                <li class="item">
                    <img width="171" height="53" src="{{asset('images/devices/webp/smart_iptv_white.webp')}}" alt="smart iptv">
                </li>
            </ul>
        </div>
        @endif
        <footer>
            <div class="container">
                <div class="row top_s">
                    <div class="about_us col-md-6">
                        <img width="118" height="48" alt="{{\App\Models\Config::whereName('about_us')->first()->value}}" 
                            src="{{asset('storage/'.\App\Models\Config::whereName('white_logo')->first()->value)}}">
                        <p>{{\App\Models\Config::whereName('about_us')->first()->value}}</p>
                    </div>
                    <div class="col-md-6">
                        <div class="links">
                            <a href="{{route('setup')}}" class="hvr-underline-from-center">setup</a>
                            @foreach (\App\Models\LegalPage::whereVisibility(1)->get() as $page)
                            <a href="{{route('page', $page->slug)}}" class="hvr-underline-from-center">{{$page->title}}</a>
                            @endforeach
                            <a href="{{route('contactus')}}" class="hvr-underline-from-center">contact us</a>
                        </div>
                    </div>
                </div>

                <div class="_footer">
                    All Rights Are Reserved To <strong>{{ config('app.name') }}</strong> <i class="fa fa-copyright" aria-hidden="true"></i> 2022
                </div>
            </div>
        </footer>
        @if( \App\Models\Config::whereName('gtag')->first()->value )
        <script async src="https://www.googletagmanager.com/gtag/js?id={{\App\Models\Config::whereName('gtag')->first()->value}}"></script>
        <script>
            window.dataLayer = window.dataLayer || [];

            function gtag() {
                dataLayer.push(arguments);
            }
            gtag('js', new Date());
            gtag('config', "{{\App\Models\Config::whereName('gtag')->first()->value}}");
        </script>
        @endif
        
        @if( env('APP_ENV') == 'local' )
        <script src="{{asset('js/app.js').'?v='.time()}}">
        @else
        <script>
            @include('layouts.inc.js')
        </script>
        @endif

        @yield('extra_js')

        @if ( \App\Models\Config::whereName('live_chat_enabled')->first()->value == 1 )
        <!--Start of Tawk.to Script-->
        <script type="text/javascript">
        var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
        (function(){
        var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
        s1.async=true;
        s1.src='https://embed.tawk.to/643363b031ebfa0fe7f76073/1gtkbqqra';
        s1.charset='UTF-8';
        s1.setAttribute('crossorigin','*');
        s0.parentNode.insertBefore(s1,s0);
        })();
        </script>
        <!--End of Tawk.to Script-->
        @endif

    </body>
</html>