@extends('layouts.app')
@section('title', config('app.name').' || Contact Us')
@section('extra_css')
<style>
.h-captcha {
    margin-top: 25px;
}
</style>
@endsection
@section('content')
<div class="container">
    <div id="contact-us">
        @if (session('success'))
        <div class="sent">
            <i class="fa fa-check-circle"></i>
            <p class="message-sent">{{session('success') }}</p>
        </div>
        @else
        <h1>Contact Us</h1>
        <form method="POST">
            @if($errors->any())
            <ul>
                @foreach ($errors->all() as $error)
                <li>{{$error}}</li>
                @endforeach
            </ul>
            @endif
            @csrf
            <input type="email" name="email" class="form-control" placeholder="Email" required>
            <input type="text" name="subject" class="form-control" placeholder="Subject">
            <textarea name="message" class="form-control" rows="7" placeholder="Message"></textarea>
            {!! app('captcha')->display() !!}
            <button type="submit" class="send_message">Send</button>
        </form>
        @endif
    </div>
</div>
@endsection