@extends('layouts.app')
@section('title', config('app.name').' || CheckOut')
@section('content')
<div class="container">
    <div id="shopping-checkout">
        <h1>Checkout</h1>
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="customer-infos auth_container">
                    <div class="header">
                        <div>
                            <input type="radio" class="form-check-input" checked>
                            <span class="title">Your Info</span>
                        </div>
                    </div>
                    <div class="body">
                        </h2>
                        <form id="payform" method="POST" action="{{route('payment.ok')}}">
                            @csrf
                            <input type="hidden" name="payment_method" id="payment_method" value="paypal">
                           <div class="row">
                                <div class="col-md-4 mb-2 form-group">
                                    <label for="billing_name">Name</label>
                                    <input type="text" class="form-control" id="billing_name" name="billing_name" placeholder="Put your name here" v-model="billing_name">
                                    <div v-if="billing_nameError" class="invalid-feedback">
                                        @{{billing_nameError}}
                                    </div>
                                </div>
                                <div class="col-md-8 form-group">
                                    <label for="billing_email">email</label>
                                    <input type="text" class="form-control" id="billing_email" name="billing_email" placeholder="Put your email here" v-model="billing_email">
                                    <div v-if="billing_emailError" class="invalid-feedback">
                                        @{{billing_emailError}}
                                    </div>
                                </div>
                                
                           </div>
                        </form>
                    </div>
                </div>
                <div class="customer-infos auth_container">
                    <div class="header">
                       <div>
                            <input type="radio" class="form-check-input" checked>
                            <span class="title">PayPal <small>( Credit / Debit Cards )</small>
                        </div>
                    </div>
                 </div>
            </div>
            <div class="col-md-4">
                <div class="customer-infos summary">
                    <div class="header">
                        <span class="title">Summary</span>
                    </div>
                    <div class="body summary">
                        <span class="subtotal">
                            {{$product_title}}
                            <p>@{{sub_total}}$</p>
                        </span>
                        <span class="subtotal" v-if="adult_enabled">
                            Adult Content
                            <p>@{{adult_price}}$</p>
                        </span>
                        <span class="subtotal" v-if="vod_enabled">
                            VOD Content
                            <p>@{{vod_price}}$</p>
                        </span>
                        <span class="subtotal" v-if="prioritize_enabled">
                            Prioritize Order
                            <p>@{{prioritize_price}}$</p>
                        </span>
                        <span class="subtotal">
                            Setup Fees
                            <p>0$</p>
                        </span>
                        <span class="total">
                            Total
                            <p>@{{total}}$</p>
                        <button style="margin-top: 15px" @click.prevent="process_payment" href="#" class="btn btn-success"><i class="fa fa-credit-card-alt"></i> Complete Payment</button>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('extra_js')
@if ( env('APP_ENV') == 'local' )
<script src="{{asset('js/vue.js')}}"></script>
@else
<script src="{{asset('js/vue.min.js')}}"></script>
@endif
<script>
    new Vue({
        el: '#shopping-checkout',
        data: {

            adult_enabled: {{$adult}},
            adult_price: {{$adult_price}},

            vod_enabled: {{$vod}},
            vod_price: {{$vod_price}},

            prioritize_enabled: {{$prioritize}},
            prioritize_price: {{$prioritize_price}},

            sub_total: {{Cart::subtotal()}},

            billing_name: '',
            billing_email: '',
            billing_nameError: '',
            billing_emailError: ''

        },
        computed: {
            total() {
                const ttl = this.sub_total + this.adult_price + this.vod_price + this.prioritize_price
                var num = Number(ttl)
                var roundedString = num.toFixed(2)
                return Number(roundedString)
            }
        },
        methods: {
            process_payment() {
                if( this.billing_name == '' && this.billing_email == '' ) {
                    this.billing_nameError = 'Name Is Required'
                    this.billing_emailError = 'Email Is Required'
                }else if( this.billing_name == '' && !this.billing_email == '' ) {
                    this.billing_nameError = 'Name Field Is Required'
                }else if( !this.billing_name == '' && this.billing_email == '' ) {
                    this.billing_emailError = 'Email Field Is Required'
                }else if( !this.validateEmail(this.billing_email) ) {
                    this.billing_emailError = 'Please Enter A Valid Email Address'
                }else {
                    this.billing_nameError = ''
                    this.billing_emailError = ''
                    document.getElementById('payform').submit()
                }
            },
            validateEmail(email) {
                return email.match(
                    /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/
                )
            },
        }
    })
</script>
@endsection

@section('extra_css')
<style>
ul.right-menu, .top-message, ul.top-menu, footer, .navbar a.order_now, .navbar a.cart_number, .navbar-toggler, .cta_btn a{
    display: none!important;
}

.top-right-menu ul li .dropdown {
    display: none;
}
#shopping-checkout .customer-infos .header .email {
    color: #c9bdbd;
    padding: 6px;
    display: block;
    text-transform: capitalize
}
#shopping-checkout .customer-infos.summary .header {
    text-align: center;
}

.form-control::placeholder {
    color: rgb(185, 185, 185)!important;
    opacity: 1;
    text-transform: capitalize
}

.form-control:-ms-input-placeholder {
    color: rgb(158, 158, 158)!important;
}

.form-control::-ms-input-placeholder {
    color: rgb(158, 158, 158)!important;
}

label {
    color: #bebebe;
    font-weight: 600;
    text-transform: capitalize;
    font-size: 15px;
    margin-block: 4px;
}

button.btn.btn-success {
    font-weight: 600;
    font-size: 15px;
    text-transform: uppercase;
}

</style>
@endsection
