@extends('layouts.app')
@section('title', $title)
@section('content')
<div class="container">
    <div id="category">
        <h1>🔥 {{$title}} 🔥</h1>
        <div class="products">
            <div class="row d-flex justify-content-center text-center">
                @foreach ($products as $product)
                <div class="col-md-4 col-lg-3 product-item animate__animated animate__fadeIn">
                    <a class="poster" href="{{route('product', $product->slug)}}"><img alt="{{$product->title}}" title="{{$product->title}}" class="image-responsive" 
                        src="{{$product->poster}}"></a>
                    <a class="title" title="{{$product->title}}" href="{{route('product', $product->slug)}}"><h1>{{$product->title}}</h1></a>
                    <span class="old_price">{{$product->old_price}}$</span>
                    @if($product->hot == 1)<span class="hot">HOT</span>@endif
                    <span class="price">{{$product->price}}$</span>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
@endsection
@section('extra_css')
<style>
div#category {
    padding: 39px 0;
}
div#category>h1 {
    font-size: 33px;
    font-weight: 800;
    color: #333;
    text-align: center;
    margin: 0;
    padding-bottom: 23px;
    padding-top: 9px;
}
</style>
@endsection