@extends('layouts.app')
@section('extra_css')
<style>
.auth-form {
   background: #030e2e;
   border-radius: 14px;
   padding: 49px 53px;
   margin: 70px 0;
   color: white;
}
h1.login_text {
    font-size: 28px;
    font-weight: 500;
    margin-bottom: 40px;
}
.form-control {
    background: #121d3d;
    color: white;
    height: 43px;
    border-color: #121d3d;
    border-radius: 12px;
}
.form-control:focus {
   background: #121d3d;
   color: white;
   border-color: #14224c;
}
.custom-control {
    padding: 7px 0;
}
.auth-form a {
    color: #e6ff00!important;
}
.auth-form p {
   margin: 0;
}
button.login {
    display: block;
    width: 100%;
    background: #05247e;
    border: none;
    border-radius: 9px;
    padding: 10px 0;
}
button.login:hover {
    background: #031c68;
    transition: 0.3s
}
</style>
@endsection
@section('title', 'Register New Account')
@section('content')
<div class="authincation">
   <div class="container">
      <div class="row justify-content-center align-items-center">
         <div class="col-md-6">
            <div class="authincation-content">
               <div class="row no-gutters">
                  <div class="col-xl-12">
                     <div class="auth-form">
                        <h4 class="text-center mb-4">Sign up your account</h4>
                        <form method="POST" action="{{ route('register') }}">
                          @csrf
                           <div class="form-group mb-4">
                              <label class="mb-2"><strong>Name</strong></label>
                              <input id="name" placeholder="Name" type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required autocomplete="name" autofocus>

                              @error('name')
                                  <span class="invalid-feedback" role="alert">
                                      <strong>{{ $message }}</strong>
                                  </span>
                              @enderror
                           </div>
                           <div class="form-group mb-4">
                              <label class="mb-2"><strong>Email</strong></label>
                              <input id="email" placeholder="E-mail" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email">

                              @error('email')
                                  <span class="invalid-feedback" role="alert">
                                      <strong>{{ $message }}</strong>
                                  </span>
                              @enderror
                           </div>
                           <div class="form-group mb-4">
                              <label class="mb-2"><strong>Password</strong></label>
                              <input id="password" placeholder="Password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password">

                              @error('password')
                                  <span class="invalid-feedback" role="alert">
                                      <strong>{{ $message }}</strong>
                                  </span>
                              @enderror
                           </div>
                           <div class="form-group">
                              <label class="mb-2"><strong>Confirm Password</strong></label>
                              <input id="password-confirm" placeholder="Confirm Password" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password">
                           </div>
                           <div class="text-center mt-4">
                              <button type="submit" class="btn btn-primary login">Sign Up</button>
                           </div>
                        </form>
                        <div class="new-account mt-3">
                           <p>Already have an account? <a class="text-primary" href="{{route('login')}}">Sign in</a></p>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
@endsection
























{{-- <!DOCTYPE html>
<html lang="en" class="h-100">
   <meta http-equiv="content-type" content="text/html;charset=UTF-8" />
   <head>
      <meta charset="utf-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width,initial-scale=1">
      <title>Register</title>
      <link href="/css/style.css" rel="stylesheet">
   </head>
   <body class="h-100">
      <div class="authincation h-100">
         <div class="container h-100">
            <div class="row justify-content-center h-100 align-items-center">
               <div class="col-md-6">
                  <div class="authincation-content">
                     <div class="row no-gutters">
                        <div class="col-xl-12">
                           <div class="auth-form">
                              <h4 class="text-center mb-4">Sign up your account</h4>
                              <form method="POST" action="{{ route('register') }}">
                                @csrf
                                 <div class="form-group">
                                    <label><strong>Name</strong></label>
                                    <input id="name" placeholder="Name" type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required autocomplete="name" autofocus>

                                    @error('name')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                 </div>
                                 <div class="form-group">
                                    <label><strong>Email</strong></label>
                                    <input id="email" placeholder="E-mail" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email">

                                    @error('email')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                 </div>
                                 <div class="form-group">
                                    <label><strong>Password</strong></label>
                                    <input id="password" placeholder="Password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password">

                                    @error('password')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                 </div>
                                 <div class="form-group">
                                    <label><strong>Confirm Password</strong></label>
                                    <input id="password-confirm" placeholder="Confirm Password" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password">
                                 </div>
                                 <div class="text-center mt-4">
                                    <button type="submit" class="btn btn-primary btn-block">Sign me up</button>
                                 </div>
                              </form>
                              <div class="new-account mt-3">
                                 <p>Already have an account? <a class="text-primary" href="{{route('login')}}">Sign in</a></p>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <script src="/vd/global/global.min.js" type="text/javascript"></script>
      <script src="/vd/bootstrap-select/dist/js/bootstrap-select.min.js" type="text/javascript"></script>
      <script src="/js/custom.min.js" type="text/javascript"></script>
      <script src="/js/deznav-init.js" type="text/javascript"></script>
   </body>
</html> --}}