@extends('layouts.adminapp')
@section('title', 'Testimonials')
@section('content')
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
  <a href="{{route('admin.testimonial_insert')}}" class="goback btn btn-danger"><i class="fa fa-plus"></i>Insert Testimonial</a>
</div>
<div class="card card-default color-palette-box">
    @if( session()->has('success') )
    <span class="badge bg-success"> {{session()->get('success')}} </span>
    @endif
    <div class="card-body">
       @if (count($testimonials) > 0)
       <table class="table">
        <thead>
          <tr>
            <th scope="col"></th>
            <th scope="col"></th>
            <th scope="col">Name</th>
            <th scope="col">Country</th>
            <th scope="col">Visibility</th>
            <th scope="col">Creation Date</th>
            <th scope="col"></th>
          </tr>
        </thead>
        <tbody>
        @foreach($testimonials as $testimonial)
          <tr class="product-table">
            <td>{{$testimonial->id}}</td>
            <td><img class="img-thumbnail" width="70px" src="{{ \Illuminate\Support\Str::contains($testimonial->poster, 'https://') ? $testimonial->poster : asset('storage/'.$testimonial->poster) }}"></td>
            <td class="title">{{ $testimonial->name }}</td>
            <td>{{ $testimonial->country }}</td>
            <td>
              <span class="badge bg-{{$testimonial->visibility == '1' ? 'success' : 'warning'}}">
                {{$testimonial->visibility == '1' ? 'Visible' : 'Draft'}}
              </span>
            </td>
            <td>{{$testimonial->created_at}}</td>
            <td class="actions">
              <a href="{{route('admin.testimonial_edit', $testimonial->id)}}"><i class="edit fa fa-pencil"></i></a>
              <a class="remove_prod" data-id="{{$testimonial->id}}" href="#"><i class="edit fa fa-trash"></i></a>
            </td>
          </tr>
        @endforeach
        </tbody>
      </table>
       @else
       <h3>No Testimonials</h3>
       @endif
    </div>
 </div>
@endsection
@section('extra_js')
<script>
$(document).ready(() => {
    $(".card-body>.badge.bg-success").fadeTo(2000, 500).slideUp(500, function(){
        $(".card-body>.badge.bg-success").slideUp(500);
    });
    $('.remove_prod').on('click', function(e) {
        e.preventDefault()
        var confirmA = confirm('Delete This Testimonial ?')
        var testimonial_id = $(this).data('id')
        var link = "{{route('admin.testimonial_delete', 5)}}"
        console.log(link)
        if(confirmA) {
        window.location.href = link.replace('/5', '/'+testimonial_id)
        }
    });
})
</script>
@endsection

@section('extra_css')
    <style>
td.title {
  background: #eee;
  width: 100%;
  display: inline-block;
  color: #333;
  padding: 19px 20px;
}
span.badge.bg-success {
  padding: 4px 7px;
}
    </style>
@endsection
