@extends('layouts.adminapp')
@section('title', 'Insert New Testimonial')
@section('content')
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
    <a href="{{route('admin.products')}}" class="goback btn btn-danger"><i class="fa fa-arrow-left"></i>Go Back</a>
 </div>
<div class="card card-default color-palette-box admin_product">
    <div class="card-body">
        <form action="{{route('admin.testimonial_save')}}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="row">
                <div class="col-md-3">
                    <label for="visibility" class="form-label">Visible</label>
                    <select name="visibility">
                        <option value="0" selected>NO</option>
                        <option value="1">YES</option>
                    </select>
                </div>
                <div class="col-md-2 mb-2">
                    <label for="score" class="form-label">Score</label>
                    <input type="number" class="form-file-input form-control" name="score" id="score" value="5">
                </div>
                <div class="col-md-5 mb-5">
                    <label for="poster" class="form-label">Poster</label>
                    <input type="file" class="form-file-input form-control" name="poster" id="poster">
                </div>
            </div>
            <div class="row">
            <div class="mb-3 col-md-6">
                    <label for="name" class="form-label">Name</label>
                    <input type="text" name="name" class="form-control" placeholder="name" id="name">
                </div>
                <div class="mb-3 col-md-6">
                    <label for="country" class="form-label">Country</label>
                    <input type="text" name="country" class="form-control" placeholder="country" id="country">
                </div>
            </div>
            <div class="row">
                <div class="mb-12 col-md-12">
                    <label for="review" class="form-label">Review</label>
                    <textarea id="review" class="form-control" name="review" cols="30" rows="5"></textarea>
                </div>
            </div>
            <div class="mb-3">
                <button class="btn btn-primary" type="submit">INSERT</button>
            </div>
        </form>
    </div>
</div>
@endsection
@section('extra_js')
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script>
    $(document).ready(function () {
        $('.ckeditor').ckeditor();
    });
</script>
@endsection
