@extends('layouts.adminapp')
@section('title', 'Edit Testimonial N°'.$testimonial->id)
@section('content')
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
    <a href="{{route('admin.testimonials')}}" class="goback btn btn-danger"><i class="fa fa-arrow-left"></i>Go Back</a>
 </div>
<div class="card card-default color-palette-box admin_product">
    <div class="card-body">
        <form action="{{route('admin.testimonial_update')}}" method="POST" enctype="multipart/form-data">
            @csrf
            <input type="hidden" name="id" value="{{$testimonial->id}}">
            <div class="row">
                <div class="col-md-3">
                    <label for="visibility" class="form-label">Visible</label>
                    <select name="visibility">
                        <option value="0" @if($testimonial->visibility == 0) selected @endif> NO </option>
                        <option value="1" @if($testimonial->visibility == 1) selected @endif> YES </option>
                    </select>
                </div>
                <div class="col-md-2 mb-2">
                    <label for="score" class="form-label">Score</label>
                    <input type="number" class="form-file-input form-control" name="score" id="score" value="{{$testimonial->score}}">
                </div>
                <div class="col-md-5 mb-5">
                    <label for="poster" class="form-label">Poster</label>
                    <input type="file" class="form-file-input form-control" name="poster" id="poster">
                </div>
            </div>
            <div class="row">
                <div class="mb-3 col-md-6">
                    <label for="name" class="form-label">Name</label>
                    <input type="text" name="name" class="form-control" placeholder="name" id="name" value="{{$testimonial->name}}">
                </div>
                <div class="mb-3 col-md-6">
                    <label for="country" class="form-label">Country</label>
                    <input type="text" name="country" class="form-control" placeholder="country" id="country" value="{{$testimonial->country}}">
                </div>
            </div>
            <div class="row">
                <div class="mb-12 col-md-12">
                    <label for="review" class="form-label">Review</label>
                    <textarea id="review" class="form-control" name="review" cols="30" rows="5">{{$testimonial->review}}</textarea>
                </div>
            </div>
            <div class="mb-3">
                <button class="btn btn-primary" type="submit">UPDATE</button>
            </div>
        </form>
    </div>
</div>
@endsection
@section('extra_js')
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script>
    $(document).ready(function () {
        $('.ckeditor').ckeditor();
    });
</script>
@endsection
