@extends('layouts.adminapp')
@section('title', 'Insert New Product')
@section('content')
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
    <a href="{{route('admin.products')}}" class="goback btn btn-danger"><i class="fa fa-arrow-left"></i>Go Back</a>
 </div>
<div class="card card-default color-palette-box admin_product">
    <div class="card-body">
        <form action="{{route('admin.product_save')}}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="row">
                <div class="mb-3 col-md-9">
                    <label for="title" class="form-label">Title</label>
                    <input type="text" name="title" class="form-control" placeholder="Title" id="title">
                </div>
                <div class="col-md-2 select">
                    <label for="visibility" class="form-label">Visible</label>
                    <select name="visibility">
                        <option value="0" selected>NO</option>
                        <option value="1">YES</option>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="mb-3 col-md-2">
                    <label for="price" class="form-label">Price</label>
                    <input type="text" name="price" class="form-control" id="price" value="0">
                </div>
                <div class="mb-3 col-md-8">
                    <label for="short_title" class="form-label">Short Title</label>
                    <input type="text" name="short_title" class="form-control" id="short_title" placeholder="Short Title">
                </div>
            </div>
            <div class="row">
                <div class="col-md-3 select">
                    <label for="category" class="form-label">Category</label>
                    <select name="category_id">
                        @foreach($categories as $category)
                        <option value="{{$category->id}}" @if($category->name == 'Other') selected @endif>{{$category->name}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3 select">
                    <label for="hot" class="form-label">Hot</label>
                    <select name="hot">
                        <option value='1'>YES</option>
                        <option value='0'>NO</option>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="col-md-8">
                    <label for="targeted_product" class="form-label">Targeted Product</label>
                    <input type="text" name="targeted_product" class="form-control" id="targeted_product" placeholder="Targeted Product">
                </div>
            </div>
            <div class="row">
                <div class="col-md-3 mb-3">
                    <label for="poster" class="form-label">Poster</label>
                    <input type="file" class="form-file-input form-control" name="poster" id="poster">
                </div>
                <div class="col-md-8">
                    <label for="tags" class="form-label">Tags</label>
                    <input type="text" name="tags" class="form-control" id="tags" placeholder="tags ...">
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <label for="description" class="form-label">Description</label>
                    <textarea rows="30" class="ckeditor form-control" id="description" name="description"></textarea>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <label for="seo_title" class="form-label">Seo Title</label>
                    <input type="text" class="form-control" name="seo_title" id="seo_title" placeholder="Seo Title">
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <label for="seo_keywords" class="form-label">Seo Keywords</label>
                    <input type="text" class="form-control" name="seo_keywords" id="seo_keywords" placeholder="Seo Keywords">
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <label for="seo_description" class="form-label">Seo Description</label>
                    <input type="text" name="seo_description" class="form-control" id="seo_description" placeholder="Seo Description">
                </div>
            </div>
            <div class="mb-3">
                <button class="btn btn-primary" type="submit">INSERT</button>
            </div>
        </form>
    </div>
</div>
@endsection
@section('extra_js')
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script>
    $(document).ready(function () {
        $('.ckeditor').ckeditor();
    });
</script>
@endsection