@extends('layouts.adminapp')
@section('title', $title)
@section('extra_css')
<link href="/vd/sweetalert2/dist/sweetalert2.min.css" rel="stylesheet" type="text/css"/>
<script src="/vd/sweetalert2/dist/sweetalert2.min.js" type="text/javascript"></script>
<style>
span.badge.bg-success {
    padding: 5px 11px;
}
span.badge.bg-warning {
    padding: 3px 16px;
    font-weight: 600;
    font-size: 13px;
}

.table_td span.badge.bg-warning, .table_td span.badge.bg-success {
    border-radius: 13px!important;
    padding: 2px 9px;
    text-transform: uppercase
}
</style>
@endsection
@section('content')
<div class="card card-default color-palette-box">
    <div class="card-body table-responsive">
        @if($orders->count() > 0)
        <table class="table">
            <thead>
                <tr>
                    <th>id</th>
                    <th>time</th>
                    <th>customer</th>
                    <th>email</th>
                    <th>refunded</th>
                    <th>sent</th>
                    <th>total</th>
                    <th>actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($orders as $order)
                <tr order-id="{{$order->id}}">
                    <th>
                        <div class="table_td">
                            #{{$order->id}}
                        </div>
                    </th>
                    <th>
                        <div class="table_td vertical">
                            <span class="badge d-block mb-1 bg-dark">{{\Carbon\Carbon::parse($order->created_at)->diffForhumans()}}</span>
                            <span class="badge d-block bg-dark">{{$order->date}}</span>
                        </div>
                    </th>
                    <th class="customer">
                        <div class="table_td">
                            {{$order->billing_name}}
                        </div>
                    </th>
                    <th class="customer">
                        <div class="table_td">
                            {{$order->billing_email}}
                        </div>
                    </th>
                    <th>
                        <div class="table_td">
                            <span class="badge bg-{{ $order->refunded ? 'success' : 'warning' }}">
                            {{ $order->refunded ? 'yes' : 'No' }}
                            </span>
                        </div>
                    </th>
                    <th>
                        <div class="table_td">
                            <span class="badge bg-{{ $order->sent ? 'success' : 'warning' }}">
                            {{ $order->sent ? 'yes' : 'Not Yet' }}
                            </span>
                        </div>
                    </th>
                    <th>
                        <div class="table_td">
                            {{$order->total}}$
                        </div>
                    </th>
                    <th class="actions">
                        <div class="table_td">
                            @if ( strtolower($title) == 'orders' )
                            <a style="margin-right: 7px" href="{{ route('admin.order', $order->id) }}"><i class="fa fa-eye"></i></a>
                            <a class="remove_order" data-url="{{route('admin.order_delete', $order->id)}}" href="#"><i class="fa fa-trash"></i></a>
                            @else
                            <a style="margin-right: 7px" href="{{ route('admin.invoice', $order->id) }}"><i class="fa fa-eye"></i></a>
                            <a class="remove_order" data-url="{{route('admin.invoice_delete', $order->id)}}" href="#"><i class="fa fa-trash"></i></a>
                            @endif
                        </div>
                    </th>
                </tr>
                @endforeach
            </tbody>
        </table>
        {!! $orders->links() !!}
        @else
        <span>You Have No {{$title}}</span>
        @endif
    </div>
 </div>
@endsection
@section('extra_js')
<script>
    $(document).ready(function() {
        $('a.remove_order').on('click', function() {
            var confirm = window.confirm('Sure ?');
            if(confirm) {
                window.location.href = $(this).data('url')
            }
        })
    })
</script>
@endsection