@extends('layouts.adminapp')
@section('extra_css')
<link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css'>

<style>
a.badge.bg-success, span.badge.bg-success {
    padding: 4px 9px;
    font-size: 12px;
}
a.badge.bg-warning {
    padding: 3px 16px;
    font-weight: 600;
    font-size: 12px;
}
span.badge.bg-danger {
    color: white;
    font-weight: 600;
    padding: 7px 0;
    font-size: 14px;
}
div#send_order {
    background: #eee;
    padding: 6px 11px;
    border-radius: 10px;
}
.datepicker.datepicker-dropdown th.datepicker-switch, .datepicker.datepicker-dropdown th.next, .datepicker.datepicker-dropdown th.prev {
    color: white;
}
.datepicker .datepicker-switch:hover, .datepicker .next:hover, .datepicker .prev:hover, .datepicker tfoot tr th:hover {
    background: #1d1b1f;
}
h4._details_title {
    color: #024591;
    font-weight: 800;
    margin-top: 30px;
}

ul.time_infos li {
    padding: 19px 30px;
    display: inline-block;
}

.badge.bg-dark {
    font-size: 11px;
}

ul.time_infos li span.name {
    display: block;
    font-size: 13px;
    color: #969494;
    text-transform: uppercase;
    font-weight: 500;
    margin-bottom: 4px;
}

ul.time_infos li span.value {
    color: #005f37;
    font-weight: 700!important;
    font-size: 14px;
}

label {
    display: block
}
.dropdown.bootstrap-select.form-select {
    width: 100%!important;
}

.filter-option-inner-inner {
    font-weight: 600;
}
</style>
@endsection
@section('title', 'Order N° '.$order->id)
@section('content')
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
    <a href="{{route('admin.orders')}}" class="goback btn btn-danger"><i class="fa fa-arrow-left"></i>Go Back</a>
</div>
<div class="card card-default color-palette-box">
    @if( session()->has('success') )
    <span class="badge bg-success"> {{session()->get('success')}} </span>
    @elseif( session()->has('error') )
    <span class="badge bg-danger"> {{session()->get('error')}} </span>
    @endif
    <div class="card-body table-responsive">
        <ul class="time_infos">
            <li>
                <span class="name">total</span>
                <span class="value">{{$order->total}}$</span>
            </li>
            <li>
                <span class="name">ordering date</span>
                <span class="value">
                    <span class="badge bg-dark">{{$order->created_at->format('F d, Y H:i')}}</span>
                </span>
            </li>
            <li>
                <span class="name">payment date</span>
                <span class="value">
                    <span class="badge bg-dark">{{$order->payment_date->format('F d, Y H:i')}}</span>
                </span>
            </li>
            <li>
                <span class="name">refunding status</span>
                <span class="value">
                    <a href="{{route('admin.set_refunded', $order->id)}}" class="badge bg-{{ $order->refunded ? 'success' : 'warning' }}">
                        {{ $order->refunded ? 'Refunded' : 'Not Refunded' }}
                    </a>
                </span>
            </li>
            <li>
                <span class="name">payment status</span>
                <span class="value">
                    <a href="{{route('admin.set_paid', $order->id)}}" class="badge bg-{{ $order->paid ? 'success' : 'warning' }}">
                        {{ $order->paid ? 'Paid' : 'Not Paid' }}
                    </a>
                </span>
            </li>
            <li>
                <span class="name">sending status</span>
                <span class="value">
                    <a href="{{route('admin.set_sent', $order->id)}}" class="badge bg-{{ $order->sent ? 'success' : 'warning' }}">
                        {{ $order->sent ? 'Sent' : 'Not Sent' }}
                    </a>
                </span>
            </li>

            <li>
                <span class="name">vod</span>
                <span class="value addon">
                    <span class="badge bg-{{ $order->vod ? 'success' : 'warning' }}"> {{$order->vod == 1 ? 'YES' : 'NO'}}</span>
                </span>
            </li>

            <li>
                <span class="name">adult</span>
                <span class="value addon">
                    <span class="badge bg-{{ $order->adult ? 'success' : 'warning' }}"> {{$order->adult == 1 ? 'YES' : 'NO'}}</span>
                </span>
            </li>
            
            <li>
                <span class="name">prioritize order</span>
                <span class="value addon">
                    <span class="badge bg-{{ $order->prioritize ? 'success' : 'warning' }}"> {{$order->prioritize == 1 ? 'YES' : 'NO'}}</span>
                </span>
            </li>



        </ul>
        <h4 class="_details_title">Order Details</h4>
        <div id="order">
            <div class="row">
                <div class="col-md-3">
                    <label for="ppl_transaction_id">PayPal Transaction ID</label>
                    <input type="text" class="form-control" id="ppl_transaction_id" value="{{$order->ppl_transaction_id}}" disabled>
                </div>
                <div class="col-md-3">
                    <label for="ppl_customer_id">PayPal Customer ID</label>
                    <input type="text" class="form-control" id="ppl_customer_id" value="{{$order->ppl_customer_id}}" disabled>
                </div>
                <div class="col-md-5">
                    <label for="ppl_email">Paypal Email</label>
                    <input type="text" class="form-control" id="ppl_email" value="{{$order->ppl_email}}" disabled>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3">
                    <label for="ppl_firstName">PayPal First Name</label>
                    <input type="text" class="form-control" id="ppl_firstName" value="{{$order->ppl_firstName}}" disabled>
                </div>
                <div class="col-md-3">
                    <label for="ppl_lastName">PayPal Last Name</label>
                    <input type="text" class="form-control" id="ppl_lastName" value="{{$order->ppl_lastName}}" disabled>
                </div>
                <div class="col-md-3">
                    <label for="ppl_country">PayPal Country</label>
                    <input type="text" class="form-control" id="ppl_country" value="{{$order->ppl_country}}" disabled>
                </div>
            </div>
            <div class="row">
                <div class="col-md-5">
                    <label for="billing_email">Billing Email</label>
                    <input type="text" class="form-control" id="billing_email" value="{{$order->billing_email}}" disabled>
                </div>
                <div class="col-md-5">
                    <label for="billing_name">Billing Name</label>
                    <input type="text" class="form-control" id="billing_name" value="{{$order->billing_name}}" disabled>
                </div>
            </div>
        </div>
        <h4 class="_details_title">Service Details</h4>
        <div id="service">
            <form action="{{route('admin.order_update_service')}}" method="POST">
                @csrf
                <input type="hidden" name="months_number" value="{{(int)$order->product->period}}">
                <input type="hidden" name="id" value="{{$order->service->id}}">
                <div class="row">
                    <div class="col-md-6">
                        <label for="subtype_id">Subscription Type</label>
                        <select class="form-select" name="subtype_id" id="subtype_id">
                            @foreach (App\Models\Subtype::all() as $subtype)
                            <option value="{{$subtype->id}}" @if( $subtype->id == $order->service->subtype_id ) selected @endif>{{$subtype->title}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label for="title">Period</label>
                        <input type="text" class="form-control" id="title" value="{{$order->service->title}}" disabled>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3">
                        <label for="activated">Activated</label>
                        <select name="activated" id="activated">
                            <option value="1" @if( $order->service->activated == 1 ) selected @endif>YES</option>
                            <option value="0" @if( $order->service->activated == 0 ) selected @endif>NO</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="activation_date">Activation Date</label> 
                        @if ($order->service->activation_date == NULL)
                        <input class="form-control" name="activation_date" type="text" id="activation_date" value="">                         
                        @else
                        <input class="form-control" name="activation_date" type="text" id="activation_date" value="{{$order->service->activation_date->format('d F, Y')}}">
                        @endif                        
                    </div>
                    <div class="col-md-3">
                        <label for="expiration_date">Expiration Date</label>
                        @if ($order->service->expiration_date == NULL)
                        <input class="form-control" name="expiration_date" type="text" id="expiration_date" value="">
                        @else
                        <input class="form-control" name="expiration_date" type="text" id="expiration_date" value="{{$order->service->expiration_date->format('d F, Y')}}">
                        @endif
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3">
                        <label for="server_id">Server</label>
                        <select name="server_id" id="server_id">
                            <option value="0">-</option>
                            @foreach (App\Models\Server::all() as $server)
                            <option value="{{$server->id}}" @if( $server->id == $order->service->server_id ) selected @endif>{{$server->name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="host">Host</label>
                        <input type="text" class="form-control" id="host" name="host" value="{{$order->service->host != '' ? $order->service->host : 'http://line.ottcdn.net'}}">
                    </div>
                    <div class="col-md-3">
                        <label for="username">UserName</label>
                        <input type="text" class="form-control" id="username" name="username" value="{{$order->service->username}}">
                    </div>
                    <div class="col-md-3">
                        <label for="password">Password</label>
                        <input type="text" class="form-control" id="password" name="password" value="{{$order->service->password}}">
                    </div>
                </div>
                <div class="row">
                    
                    <div class="col-md-3">
                        <label for="price">Price</label>
                        <input type="text" class="form-control" id="price" value="{{$order->service->price}} $" disabled>
                    </div>
                    <div class="col-md-3">
                        <label for="mac_address">Mac Address</label>
                        <input type="text" class="form-control" id="mac_address" name="mac_address" value="{{$order->service->mac_address}}">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 mb-3">
                        <label for="m3u">M3U</label>
                        <input type="text" class="form-control" id="m3u" name="m3u" value="{{$order->service->m3u}}">
                    </div>
                    <div class="col-md-12">
                        <label for="epg">EPG</label>
                        <input type="text" class="form-control" id="epg" name="epg" value="{{$order->service->epg}}">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 mb-4">
                        <label for="enigma">Enigma</label>
                        <textarea class="form-control" name="enigma" id="" cols="30" rows="3">{{$order->service->enigma}}</textarea>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <label for="notes">Notes</label>
                        <textarea class="form-control" name="notes" id="notes" cols="30" rows="10">{{$order->service->notes}}</textarea>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <button type="submit" class="btn btn-success">Update</button>
                    </div>
                </div>
            </form>
        </div>
        @if ( $order->service->activated )
        <div id="send_order">
            <form action="{{route('admin.send_order')}}" method="POST">
                @csrf
                <input type="hidden" name="id" value="{{$order->id}}">
                <div class="row">
                    <div class="col-md-6">
                        <label for="email">Send Order Details</label>
                        <input type="email" class="form-control" name="email" value="{{$order->billing_email}}">
                    </div>
                    <div class="col-md-6">
                        <button type="submit" class="btn btn-primary">Send</button>
                    </div>
                </div>
            </form>
        </div>
        @endif
    </div>
 </div>
@endsection
@section('extra_js')
<script src='https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js'></script>
<script>
    $(document).ready(() => {
        $(".card>.badge.bg-success").fadeTo(2000, 500).slideUp(500, function(){
            $(".card>.badge.bg-success").slideUp(500);
        })
        $.fn.datepicker.defaults.format = "dd MM, yyyy"
        $('#activation_date').datepicker()
        $('#expiration_date').datepicker()
    })
</script>
@endsection
