<?php

namespace Database\Seeders;

use App\Models\Question;
use Illuminate\Database\Seeder;

class QuestionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Question::create([
            'question' => 'What does the package include ?',
            'answer' => "When you subscribe to ".config('app.name').", you get login credentials to IPTV server with instructions for how to setup it on your device",
            'visibility' => true
        ]);

        Question::create([
            'question' => 'Do you offer free trial ?',
            'answer' => "Yes we offer free trial just contact us using whatsapp or live chat or use our <a href='".route('contactus')."'>Contact Page</a>",
            'visibility' => true
        ]);


        Question::create([
            'question' => 'How to setup IPTV on my device?',
            'answer' => "It is very easy to connect IPTV. Follow the <a href='{{route('setup')}}'>Tutorial Page</a>, chat with us or send an email, our agents will help you set it up on your device",
            'visibility' => true
        ]);

        Question::create([
            'question' => 'What Devices You support ?',
            'answer' => "We support all kinds of devices such as <code>Smart TVs, Firestick, MAG, Android Smart Phone, Android Boxes, Enigma, DreamBox, Vu+ (…), PC, VLC, Smart TV.</code>",
            'visibility' => true
        ]);

        Question::create([
            'question' => 'How long will it take to receive my IPTV access ?',
            'answer' => "We aim to email you within 3min to 6 hours of purchase to arrange setup of your order. Please note during busy periods at evenings and weekends orders may take up to 2 hours to process",
            'visibility' => true
        ]);

        Question::create([
            'question' => 'What if i don\'t like your IPTV service?',
            'answer' => "We offer a 3 Days Money Back Guarantee if you didn't like our service.",
            'visibility' => true
        ]);

        Question::create([
            'question' => 'What content do you supply ?',
            'answer' => "We offer a full range of Canada, USA, UK, European, African And Asian channels, movies, series and TV shows with Catch Up & EPG (Electronic Program Guide) features in 8K / 4K / Ultra HD / HD quality.",
            'visibility' => true
        ]);
    }
}
