<?php

namespace Database\Seeders;

use App\Models\Product;
use Illuminate\Database\Seeder;

class ProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $oneDevicesAllowed = false;
        $twoDevicesAllowed = false;
        $threeDevicesAllowed = false;
        $fourDevicesAllowed = true;
        if( $oneDevicesAllowed ) {
            Product::create([
                'category_id' => 1,
                'title' => 'IPTV Premium Quality 1 Month Subscription',
                'short_title' => 'IPTV Premium 1 Month',
                'period' => '1 Month',
                'price' => 11.99,
                'old_price' => 20.99,
                'seo_title' => 'IPTV Premium Quality 1 Month Subscription',
                'seo_keywords' => 'iptv 1 month, iptv for 1 month, 1 month subscription iptv, premium iptv',
                'seo_description' => 'IPTV Premium Quality 1 Month Subscription',
                'visibility' => true,
                'in_stock' => true,
                'hot' => false,
                'targeted_product' => 1
            ]);
            Product::create([
                'category_id' => 1,
                'title' => 'IPTV Premium Quality 3 Months Subscription',
                'short_title' => 'IPTV Premium 3 Months',
                'period' => '3 Months',
                'price' => 19.99,
                'old_price' => 28.99,
                'seo_title' => 'IPTV Premium Quality 3 Months Subscription',
                'seo_keywords' => 'iptv 3 months, iptv for 3 months, 3 months subscription iptv, premium iptv',
                'seo_description' => 'IPTV Premium Quality 3 Months Subscription',
                'visibility' => true,
                'in_stock' => true,
                'hot' => false,
                'targeted_product' => 2
            ]);
            Product::create([
                'category_id' => 1,
                'title' => 'IPTV Premium Quality 6 Months Subscription',
                'short_title' => 'IPTV Premium 6 Months',
                'period' => '6 Months',
                'price' => 32.99,
                'old_price' => 41.99,
                'seo_title' => 'IPTV Premium Quality 6 Months Subscription',
                'seo_keywords' => 'iptv 6 months, iptv for 6 months, 6 months subscription iptv, premium iptv',
                'seo_description' => 'IPTV Premium Quality 6 Months Subscription',
                'visibility' => true,
                'in_stock' => false,
                'hot' => false,
                'targeted_product' => 3
            ]);
            Product::create([
                'category_id' => 1,
                'title' => 'IPTV Premium Quality 12 Months ( 1 YEAR ) Subscription',
                'short_title' => 'IPTV Premium 12 Months',
                'period' => '12 Months',
                'price' => 49.99,
                'old_price' => 58.99,
                'seo_title' => 'IPTV Premium Quality 12 Months ( 1 YEAR ) Subscription',
                'seo_keywords' => 'iptv 12 months, iptv for 12 months, 12 months subscription iptv, premium iptv',
                'seo_description' => 'IPTV Premium Quality 12 Months ( 1 YEAR ) Subscription',
                'visibility' => true,
                'in_stock' => true,
                'hot' => true,
                'targeted_product' => 4
            ]);
        }
        /**
         * FOR 2 DEVICES;
        */
        if( $twoDevicesAllowed ) {
            Product::create([
                'category_id' => 2,
                'title' => 'IPTV Premium Quality 1 Month Subscription ( 2 Devices )',
                'short_title' => 'IPTV Premium 1 Month ( 2 Devices )',
                'period' => '1 Month',
                'price' => 20.99,
                'old_price' => 36.99,
                'seo_title' => 'IPTV Premium Quality 1 Month Subscription ( 2 Devices )',
                'seo_keywords' => 'iptv 1 month multiroom, iptv for 1 month multiroom, 1 month subscription iptv multiroom, premium iptv',
                'seo_description' => 'IPTV Premium Quality 1 Month Subscription ( 2 Devices )',
                'visibility' => true,
                'in_stock' => true,
                'hot' => false,
                'targeted_product' => 5
            ]);
            Product::create([
                'category_id' => 2,
                'title' => 'IPTV Premium Quality 3 Months Subscription ( 2 Devices )',
                'short_title' => 'IPTV Premium 3 Months ( 2 Devices )',
                'period' => '3 Months',
                'price' => 34.99,
                'old_price' => 51.99,
                'seo_title' => 'IPTV Premium Quality 3 Months Subscription ( 2 Devices )',
                'seo_keywords' => 'iptv 3 months multiroom, iptv for 3 months multiroom, 3 months subscription iptv multiroom, premium iptv',
                'seo_description' => 'IPTV Premium Quality 3 Months Subscription ( 2 Devices )',
                'visibility' => true,
                'in_stock' => true,
                'hot' => false,
                'targeted_product' => 6
            ]);
            Product::create([
                'category_id' => 2,
                'title' => 'IPTV Premium Quality 6 Months Subscription ( 2 Devices )',
                'short_title' => 'IPTV Premium 6 Months ( 2 Devices )',
                'period' => '6 Months',
                'price' => 61.99,
                'old_price' => 83.99,
                'seo_title' => 'IPTV Premium Quality 6 Months Subscription ( 2 Devices )',
                'seo_keywords' => 'iptv 6 months multiroom, iptv for 6 months multiroom, 6 months subscription iptv multiroom, premium iptv',
                'seo_description' => 'IPTV Premium Quality 6 Months Subscription ( 2 Devices )',
                'visibility' => true,
                'in_stock' => true,
                'hot' => false,
                'targeted_product' => 7
            ]);
            Product::create([
                'category_id' => 2,
                'title' => 'IPTV Premium Quality 12 Months Subscription ( 2 Devices )',
                'short_title' => 'IPTV Premium 12 Months ( 2 Devices )',
                'period' => '12 Months',
                'price' => 85.99,
                'old_price' => 114.99,
                'seo_title' => 'IPTV Premium Quality 12 Months Subscription ( 2 Devices )',
                'seo_keywords' => 'iptv 12 months multiroom, iptv for 12 months multiroom, 12 months subscription iptv multiroom, premium iptv',
                'seo_description' => 'IPTV Premium Quality 12 Months Subscription ( 2 Devices )',
                'visibility' => true,
                'in_stock' => true,
                'hot' => true,
                'targeted_product' => 8
            ]);
        }
        /**
         * FOR 3 DEVICES;
        */
        if( $threeDevicesAllowed ) {
            Product::create([
                'category_id' => 3,
                'title' => 'IPTV Premium Quality 1 Month Subscription ( 3 Devices )',
                'short_title' => 'IPTV Premium 1 Month ( 3 Devices )',
                'period' => '1 Month',
                'price' => 35.99,
                'old_price' => 42.99,
                'seo_title' => 'IPTV Premium Quality 1 Month Subscription ( 3 Devices )',
                'seo_keywords' => 'iptv 1 month multiroom, iptv for 1 month multiroom, 1 month subscription iptv multiroom, premium iptv',
                'seo_description' => 'IPTV Premium Quality 1 Month Subscription ( 3 Devices )',
                'visibility' => true,
                'in_stock' => true,
                'hot' => false,
                'targeted_product' => 6
            ]);
            Product::create([
                'category_id' => 3,
                'title' => 'IPTV Premium Quality 3 Months Subscription ( 3 Devices )',
                'short_title' => 'IPTV Premium 3 Months ( 3 Devices )',
                'period' => '3 Months',
                'price' => 59.99,
                'old_price' => 66.99,
                'seo_title' => 'IPTV Premium Quality 3 Months Subscription ( 3 Devices )',
                'seo_keywords' => 'iptv 3 months multiroom, iptv for 3 months multiroom, 3 months subscription iptv multiroom, premium iptv',
                'seo_description' => 'IPTV Premium Quality 3 Months Subscription ( 3 Devices )',
                'visibility' => true,
                'in_stock' => true,
                'hot' => false,
                'targeted_product' => 6
            ]);
            Product::create([
                'category_id' => 3,
                'title' => 'IPTV Premium Quality 6 Months Subscription ( 3 Devices )',
                'short_title' => 'IPTV Premium 6 Months ( 3 Devices )',
                'period' => '6 Months',
                'price' => 91.99,
                'old_price' => 98.99,
                'seo_title' => 'IPTV Premium Quality 6 Months Subscription ( 3 Devices )',
                'seo_keywords' => 'iptv 6 months multiroom, iptv for 6 months multiroom, 6 months subscription iptv multiroom, premium iptv',
                'seo_description' => 'IPTV Premium Quality 6 Months Subscription ( 3 Devices )',
                'visibility' => true,
                'in_stock' => true,
                'hot' => false,
                'targeted_product' => 6
            ]);
            Product::create([
                'category_id' => 3,
                'title' => 'IPTV Premium Quality 12 Months Subscription ( 3 Devices )',
                'short_title' => 'IPTV Premium 12 Months ( 3 Devices )',
                'period' => '12 Months',
                'price' => 143.99,
                'old_price' => 150.99,
                'seo_title' => 'IPTV Premium Quality 12 Months Subscription ( 3 Devices )',
                'seo_keywords' => 'iptv 12 months multiroom, iptv for 12 months multiroom, 12 months subscription iptv multiroom, premium iptv',
                'seo_description' => 'IPTV Premium Quality 12 Months Subscription ( 3 Devices )',
                'visibility' => true,
                'in_stock' => true,
                'hot' => true,
                'targeted_product' => 6
            ]);
        }
        if( $fourDevicesAllowed ) {
            Product::create([
                'category_id' => 4,
                'title' => 'IPTV Premium Quality 1 Month Subscription ( 4 Connections )',
                'short_title' => 'IPTV Premium 1 Month ( 4 Connections )',
                'period' => '1 Month',
                'price' => 38.99,
                'old_price' => 47.99,
                'seo_title' => 'IPTV Premium Quality 1 Month Subscription ( 4 Connections )',
                'seo_keywords' => 'iptv 1 month multiroom, iptv for 1 month multiroom, 1 month subscription iptv multiroom, premium iptv',
                'seo_description' => 'IPTV Premium Quality 1 Month Subscription ( 4 Connections )',
                'visibility' => true,
                'in_stock' => true,
                'hot' => false,
                'targeted_product' => 6
            ]);
            Product::create([
                'category_id' => 4,
                'title' => 'IPTV Premium Quality 3 Months Subscription ( 4 Connections )',
                'short_title' => 'IPTV Premium 3 Months ( 4 Connections )',
                'period' => '3 Months',
                'price' => 63.99,
                'old_price' => 79.96,
                'seo_title' => 'IPTV Premium Quality 3 Months Subscription ( 4 Connections )',
                'seo_keywords' => 'iptv 3 months multiroom, iptv for 3 months multiroom, 3 months subscription iptv multiroom, premium iptv',
                'seo_description' => 'IPTV Premium Quality 3 Months Subscription ( 4 Connections )',
                'visibility' => true,
                'in_stock' => true,
                'hot' => false,
                'targeted_product' => 6
            ]);
            Product::create([
                'category_id' => 4,
                'title' => 'IPTV Premium Quality 6 Months Subscription ( 4 Connections )',
                'short_title' => 'IPTV Premium 6 Months ( 4 Connections )',
                'period' => '6 Months',
                'price' => 105.99,
                'old_price' => 131.99,
                'seo_title' => 'IPTV Premium Quality 6 Months Subscription ( 4 Connections )',
                'seo_keywords' => 'iptv 6 months multiroom, iptv for 6 months multiroom, 6 months subscription iptv multiroom, premium iptv',
                'seo_description' => 'IPTV Premium Quality 6 Months Subscription ( 4 Connections )',
                'visibility' => true,
                'in_stock' => true,
                'hot' => false,
                'targeted_product' => 6
            ]);
            Product::create([
                'category_id' => 4,
                'title' => 'IPTV Premium Quality 12 Months Subscription ( 4 Connections )',
                'short_title' => 'IPTV Premium 12 Months ( 4 Connections )',
                'period' => '12 Months',
                'price' => 159.99,
                'old_price' => 199.99,
                'seo_title' => 'IPTV Premium Quality 12 Months Subscription ( 4 Connections )',
                'seo_keywords' => 'iptv 12 months multiroom, iptv for 12 months multiroom, 12 months subscription iptv multiroom, premium iptv',
                'seo_description' => 'IPTV Premium Quality 12 Months Subscription ( 4 Connections )',
                'visibility' => true,
                'in_stock' => true,
                'hot' => true,
                'targeted_product' => 6
            ]);
        }
    }
}
