<?php

namespace Database\Seeders;

use App\Models\Post;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\File;

class PostSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $link1 = File::copy(public_path('images/blog/buzztv-xr-4000.webp'), 'storage/app/public/buzztv-xr-4000.webp');
        $link2 = File::copy(public_path('images/blog/How-to-setup-ipt-v.webp'), 'storage/app/public/How-to-setup-ipt-v.webp');
        $link3 = File::copy(public_path('images/blog/ios.webp'), 'storage/app/public/ios.webp');
        $link4 = File::copy(public_path('images/blog/iptv-firestack.webp'), 'storage/app/public/iptv-firestack.webp');
        $link5 = File::copy(public_path('images/blog/mac-address.webp'), 'storage/app/public/mac-address.webp');
        $link6 = File::copy(public_path('images/blog/mag.webp'), 'storage/app/public/mag.webp');
        $link7 = File::copy(public_path('images/blog/netiptv.webp'), 'storage/app/public/netiptv.webp');
        $link8 = File::copy(public_path('images/blog/smarters-pro.webp'), 'storage/app/public/smarters-pro.webp');
        $link9 = File::copy(public_path('images/blog/windows-vlc.webp'), 'storage/app/public/windows-vlc.webp');

        $link1 = 'buzztv-xr-4000.webp';
        $link2 = 'How-to-setup-ipt-v.webp';
        $link3 = 'ios.webp';
        $link4 = 'iptv-firestack.webp';
        $link5 = 'mac-address.webp';
        $link6 = 'mag.webp';
        $link7 = 'netiptv.webp';
        $link8 = 'smarters-pro.webp';
        $link9 = 'windows-vlc.webp';


        Post::create([
            'title' => 'How To Set Up IPTV On BuzzTV XR 4000 ?',
            'slug' => 'how-to-set-up-iptv-on-buzztv-xr-4000',
            'visibility' => 1,
            'poster' => $link1,
            'content' => '<p>BuzzTV XR 4000 Series TV box is an android iptv cable box. It&rsquo;s compatible with both MAC address and m3u link</p><p>So it&rsquo;s a versatile tv box which is easy to use</p><p>here is the tutorial of how to setup iptv on it</p><ol><li>Go to<strong>&nbsp;Live TV&nbsp;</strong>section</li></ol><p><img alt="" src="'.asset('images/blog/how-to-set-up-iptv-on-buzztv-xr-4000/webp/1.webp').'" style="height:467px; width:1000px"/></p><p>2. From there, you can see 2 options to activate IPTV:&nbsp;<strong>Streaming Line</strong>&nbsp;and<strong>&nbsp;M3U</strong>, you can choose one of these 2 options, but we most&nbsp;<strong>recommend using m3u</strong></p><p>3. If you choose<strong>&nbsp;Streaming line&nbsp;</strong>which requires you to provide the mac address to us, then we will activate your mac address and send you a&nbsp;<strong>portal url</strong>&nbsp;in return</p><p><img alt="" src="'.asset('images/blog/how-to-set-up-iptv-on-buzztv-xr-4000/webp/2.webp').'" style="height:465px; width:1000px"/></p><p><img alt="" src="'.asset('images/blog/how-to-set-up-iptv-on-buzztv-xr-4000/webp/3.webp').'" style="height:459px; width:1000px"/></p><p>4. If you choose&nbsp;<strong>M3U&nbsp;</strong>option which is more convenient, just enter the m3u link from us</p><p><img alt="" src="'.asset('images/blog/how-to-set-up-iptv-on-buzztv-xr-4000/webp/4.webp').'" style="height:458px; width:1000px"/><img alt="" src="'.asset('images/blog/how-to-set-up-iptv-on-buzztv-xr-4000/webp/5.webp').'" style="height:451px; width:1000px"/></p>',
            'seo_title' => 'How to Set up IPTV on BuzzTV XR 4000 ?',
            'seo_keywords' => 'Set up IPTV on BuzzTV XR 4000 ,  BuzzTV XR 4000 , iptv 12 months',
            'seo_description' => 'How to Set up IPTV on BuzzTV XR 4000 ?',
        ]);
        Post::create([
            'title' => 'How to setup IPTV  on "Flix IPTV" app ?',
            'slug' => 'how-to-setup-iptv-on-flix-iptv-app',
            'visibility' => 1,
            'poster' => $link2,
            'content' => '<p>1. You need to buy an activation for your Flix IPTV app from its offical website https://flixiptv.eu/activation</p><p>2. Open this app, &nbsp;In the left-hand menu, navigate to&nbsp;Settings.&nbsp;</p><p><img alt="" src="'.asset('images/blog/how-to-setup-iptv-on-flix-iptv-app/webp/1.webp').'" style="height:432px; width:768px"/></p><p>3.&nbsp;On the following menu, scroll down to User Account.</p><p><img alt="" src="'.asset('images/blog/how-to-setup-iptv-on-flix-iptv-app/webp/2.webp').'" style="height:563px; width:1000px"/></p><p>4.&nbsp;On the User Account screen, take note of the&nbsp;Mac address.</p><p><img alt="" src="'.asset('images/blog/how-to-setup-iptv-on-flix-iptv-app/webp/3.webp').'" style="height:563px; width:1000px"/></p><p>5.&nbsp;Open a web browser on your desktop or phone and navigate to the following address:&nbsp;<strong>https://flixiptv.eu/mylist</strong></p><p>This Flix page will ask you to fill in the&nbsp;<strong>Mac address</strong>&nbsp;and&nbsp;<strong>URL link</strong>&nbsp;for the IPTV service. if you subscribe to our IPTV service, we will send login details and a m3u link, please upload the m3u to on this page&nbsp;<strong>https://flixiptv.eu/mylist</strong></p><p>6.&nbsp;After adding the information, click the&nbsp;Send&nbsp;button and you are good to go.</p><p><img alt="" src="'.asset('images/blog/how-to-setup-iptv-on-flix-iptv-app/webp/4.webp').'" style="height:477px; width:1000px"/></p><p>7. Open Flix IPTV on your FireStick and you will see the connected IPTV provider in the app.</p><p><img alt="" src="'.asset('images/blog/how-to-setup-iptv-on-flix-iptv-app/webp/5.webp').'" style="height:563px; width:1000px"/></p><h2>About Parental control over app Flix IPTV</h2><p>Parental control: Block your children&rsquo;s access to adult content by setting up Parental control in the app, under Settings. The default password for parental control is 0000.</p><p><strong>( Our Server Don&#39;t Offer Adult Content BTW, but just to be informed if you are using another subscription&nbsp;)</strong></p><p><strong><img alt="" src="'.asset('images/blog/how-to-setup-iptv-on-flix-iptv-app/webp/6.webp').'" style="height:563px; width:1000px"/></strong></p>',
            'seo_title' => 'How to setup iptv  on “Flix IPTV” app ?',
            'seo_keywords' => 'Flix IPTV app, setup iptv  on Flix IPTV app',
            'seo_description' => 'How to setup iptv  on “Flix IPTV” app ?',
        ]);

        Post::create([
            'title' => 'How to Setup IPTV  On "NET IPTV" app ?',
            'slug' => 'how-to-setup-iptv-on-net-iptv-app',
            'visibility' => 1,
            'poster' => $link7,
            'content' => '<p>1. Find Mac address. Open application and you can see the MAC address , If not , navigate to info ( by pressing RED button usually )</p><p><img alt="" src="'.asset('images/blog/how-to-setup-iptv-on-net-iptv-app/webp/1.webp').'" style="height:495px; width:881px"/></p><p>Upload M3u link via portal- Open app upload page via browser : http://netiptv.eu/Upload</p><p>2. Enter your &nbsp;mac address &nbsp;in MAC / APP ID field under UPLOAD m3U/URL row, &nbsp;Then press Add List</p><p><img alt="" src="'.asset('images/blog/how-to-setup-iptv-on-net-iptv-app/webp/2.webp').'" style="height:504px; width:873px"/></p><p>3. Enter m3u link and update- Enter The m3u link you received from provider in&nbsp;URL1&nbsp;field</p><p>Click&nbsp;Update List</p><p>Done</p><p>You need back to net IPTV app and press&nbsp;number 0&nbsp;on the remote control to reload the list.</p><p><img alt="" src="'.asset('images/blog/how-to-setup-iptv-on-net-iptv-app/webp/3.webp').'" style="height:513px; width:878px"/></p>',
            'seo_title' => 'How to Setup IPTV  On "NET IPTV" app ?',
            'seo_keywords' => 'How to Setup IPTV  On "NET IPTV" app ?, NET IPTV app, net iptv world cup 2022',
            'seo_description' => 'How to Setup IPTV  On "NET IPTV" app ?',
        ]);

        Post::create([
            'title' => 'HOW TO SETUP IPTV SMARTERS APP ON ANDROID AND IOS ?',
            'slug' => 'how-to-setup-iptv-smarters-app-on-android-and-ios',
            'visibility' => 1,
            'poster' => $link8,
            'content' => '<p>To setup <strong>IPTV Smarters pro app</strong> on Android and iOS, all you need to do is head over to the google play store (in case of Android device) and App store (in case you are using an Apple device). Now, just follow the steps mentioned below.</p><p><strong>Step 1:</strong> Within the search box, search for IPTV Smarters Pro app. Once found, click on the install button.</p><p><strong>Step 2:</strong> Once installed, open the IPTV Smarters Pro app and click on the &ldquo;add new user&rdquo;.</p><p><strong>Step 3:</strong> Now, you need to login into the app. There are two ways to do so. Either by using M3U playlist or by using the username and password that is the Xtream codes API.</p><p>The username and password can be found by looking at the URL we provide to you when you make a purchase. If you do not have/know the necessary details, please contact us by using the page up above or by using our whatsapp.</p><p><strong>Step 4: </strong>Once you are done logging in, you will be redirected to the list users screen as shown below. Click on the profile you just created.</p><p><strong>Step 5:</strong> Congratulations, you have now successfully set up and configured the IPTV Smarters Pro app on your devices.</p>',
            'seo_title' => 'HOW TO SETUP IPTV SMARTERS APP ON ANDROID AND IOS ?',
            'seo_keywords' => 'iptv smarters app, iptv, iptv world cup 2022, qatar 2022 iptv',
            'seo_description' => 'HOW TO SETUP IPTV SMARTERS APP ON ANDROID AND IOS ?',
        ]);

        Post::create([
            'title' => 'How To Setup IPTV On WINDOWS 10/11 ?',
            'slug' => 'how-to-setup-iptv-on-windows-1011',
            'visibility' => 1,
            'poster' => $link9,
            'content' => '<p>go to vlc official website and download the latest version : <a href="https://www.videolan.org/vlc/download-windows.html">Click Here To Go There</a></p><p><img alt="" src="'.asset('images/blog/how-to-setup-iptv-on-windows-1011/webp/1.webp').'" style="height:465px; width:908px"/></p><p>click on &quot;Download VLC&quot; and install it.</p><p>after installation is completed, go open it, drag and drop the m3u file we gave you on the interface of the software, it will be like that</p><p><img alt="" src="'.asset('images/blog/how-to-setup-iptv-on-windows-1011/webp/2.webp').'" style="height:537px; width:1000px"/></p>',
            'seo_title' => 'How To Setup IPTV On WINDOWS 10/11 ?',
            'seo_keywords' => 'iptv on windows, iptv windows 10, iptv windows 11, windows 11 iptv, iptv windows',
            'seo_description' => 'How To Setup IPTV On WINDOWS 10/11 ?',
        ]);

        Post::create([
            'title' => 'How to Setup IPTV on  Apple TV/iPhone/iPad and  other IOS devices?',
            'slug' => 'how-to-setup-iptv-on-apple-tviphoneipad-and-other-ios-devices',
            'visibility' => 1,
            'poster' => $link3,
            'content' => '<p>IOS users don&rsquo;t have much apps to choose compared with Android device users. No worries, there is still a few applications available in the app store</p><p>Please install GSE IPTV on your ios device, here is the setup Tutorial</p><p>Go visit App Store and download the App &ldquo;GSE IPTV&rdquo;, install this App and enter the welcome panel&nbsp;where you need to fill out the login details:</p><p><strong>Anyname:</strong> whatever you feel like, it doesn&rsquo;t matter</p><p><strong>Username: </strong>we will send you via Email within 6 hours after the purchase.</p><p><strong>Password:</strong> we will send you via Email within 6&nbsp;hours after the purchase.</p><p><strong>URL: </strong>the link we will send you via Email within 6&nbsp;hours after the purchase.</p><p>Then click on ADD USER, you are good to go</p><p><img alt="" src="'.asset('images/blog/how-to-setup-iptv-on-apple-tviphoneipad-and-other-ios-devices/webp/1.webp').'" style="height:763px; width:383px"/></p><p>&nbsp;</p><p><img alt="" src="'.asset('images/blog/how-to-setup-iptv-on-apple-tviphoneipad-and-other-ios-devices/webp/2.webp').'" style="height:765px; width:383px"/></p><p>&nbsp;</p><p><img alt="" src="'.asset('images/blog/how-to-setup-iptv-on-apple-tviphoneipad-and-other-ios-devices/webp/3.webp').'" style="height:760px; width:383px"/></p>',
            'seo_title' => 'How to Setup IPTV on  Apple TV/iPhone/iPad and  other IOS devices?',
            'seo_keywords' => 'iptv on ios, iptv ios subscription, iPad iptv',
            'seo_description' => 'How to Setup IPTV on  Apple TV/iPhone/iPad and  other IOS devices?',
        ]);

        Post::create([
            'title' => 'How to setup IPTV on Amazon Firestick ?',
            'slug' => 'how-to-setup-iptv-on-amazon-firestick',
            'visibility' => 1,
            'poster' => $link4,
            'content' => '<p>After signing up for the IPTV services, you will need to install the smarter IPTV app on your device. We will show you how to install the smarter app on FireStick. This part is easy. Just make sure you follow each step carefully.</p><h2>STEP 1: Enable Unknown Sources</h2><p>#1. Navigate to and open Settings from the menu on the top</p><p>#2. Click &lsquo;Device&rsquo; from the available options on the next screen</p><p><img alt="" src="'.asset('images/blog/how-to-setup-iptv-on-amazon-firestick/webp/1.webp').'" style="height:355px; width:660px"/></p><p># 3. Click on &lsquo;Developer Options&rsquo;</p><p># 4. Select &lsquo;Apps from Unknown Sources&rsquo; and turn it ON. This will allow you to install apps from third-party sources. It is for the apps that are not available on the Amazon App Store or other app stores.</p><p><img alt="" src="'.asset('images/blog/how-to-setup-iptv-on-amazon-firestick/webp/2.webp').'" style="height:339px; width:628px"/></p><p>Note: Unknown Sources option should only be turned on when you are absolutely confident of the installation source. Set TV FireStick is a trusted app and you can freely install it on the device without any worries.</p><p>Now go back to the FireStick home screen.</p><h2>STEP 2: Install the &lsquo;Downloader&rsquo; App</h2><p>If you already have the Downloader app on your Fire TV / Stick, you can directly go to Step 3. If you don&rsquo;t have it yet, follow the steps below.</p><p>Downloader is a very popular app on FireStick and it will help you get Set TV IPTV on the device. This app is available for free on the Amazon App Store.</p><p>Follow the steps below to download and install the Downloader app:</p><p>1. On the FireStick home screen, hover over the search icon on the top left.</p><p>2. Type in the term &lsquo;Downloader&rsquo; (without quotes).</p><p><img alt="" src="'.asset('images/blog/how-to-setup-iptv-on-amazon-firestick/webp/3.webp').'" style="height:371px; width:641px"/></p><p>3. Select &lsquo;Downloader&rsquo; from the list that populates as you type</p><p>4. Select the Get button and complete the installation</p><p><img alt="" src="'.asset('images/blog/how-to-setup-iptv-on-amazon-firestick/webp/4.webp').'" style="height:371px; width:641px"/></p><h2>STEP 3: Download and Install Set TV FireStick App Using Downloader App</h2><p>Now we are going to use the Downloader app to install the Set TV IPTV app.</p><p>Open the Downloader app from the home screen. It will appear in the &lsquo;Recent&rsquo; section since you have just downloaded it. If you don&rsquo;t see it there, open it from the App Drawer</p><p>Here, you will be required to enter the location of the APK file for Set TV IPTV. APK is the application file for the Android platform that is used to install and run the apps. It is like the EXE files on the Windows platform and DMG on Mac OS. Enter the following URL to download the APK</p><p><a href="https://cutt.ly/nQBCsXC"><strong>https://cutt.ly/nQBCsXC</strong></a></p><p><strong>(IPTV Smarters)</strong></p><p><img alt="" src="'.asset('images/blog/how-to-setup-iptv-on-amazon-firestick/webp/5.webp').'" style="height:462px; width:795px"/></p><p>Click on &lsquo;GO&rsquo; once you have entered the URL (make sure that you have typed in the correct address or the app will not install).</p><p>The APK file will now download on your device. Again, it shouldn&rsquo;t take more than a minute.</p><p>Once the file downloads, a message will appear on the screen asking for your confirmation to install the application. Press the down key on your remote twice and click &lsquo;Install&rsquo; on the bottom right</p><p>After the completion of the installation, you will see a confirmation message stating &lsquo;App Installed&rsquo; with two buttons &lsquo;Done&rsquo; &amp; &lsquo;Open.</p><p>&nbsp;</p><p>&nbsp;</p>',
            'seo_title' => 'How to setup IPTV on Amazon Firestick ?',
            'seo_keywords' => 'iptv on amazon Firestick, amazon Firestick iptv subscription',
            'seo_description' => 'How to setup IPTV on Amazon Firestick ?',
        ]);

        Post::create([
            'title' => 'What is MAC address in MAG devices?',
            'slug' => 'what-is-mac-address-in-mag-devices',
            'visibility' => 1,
            'poster' => $link5,
            'content' => '<p>MAC, an acronym of&nbsp;<strong>Media Access Control address</strong>, is a unique feature which identifies device manufacturers&rsquo; registered number and will be usable when the device has to be utilized in network environments.<br/>Each MAG device is specified with a particular MAC address that should be registered in the servers of the&nbsp;IPTV&nbsp;provider.</p><p>If the users want to change their&nbsp;MAG&nbsp;device, use another&nbsp;MAG&nbsp;device, the new MAC address has to be replaced by the old one in the servers.&nbsp;<a href="'.route('post', 'how-to-setup-iptv-on-a-mag-device').'" target="_blank">How to setup IPTV on MAG.</a></p><h2>Where to find the MAC address</h2><p>In order to find the MAC address of your MAG box, simply&nbsp;turn the box around&nbsp;and you can find the MAC address on the backside of your device. The Mac address&nbsp;usually starts with&nbsp;00:1A:79&nbsp;and the rest of the numbers and characters are exclusive to each box.</p><p><img alt="" src="'.asset('images/blog/what-is-mac-address-in-mag-devices/webp/1.webp').'" style="height:620px; width:1000px"/></p>',
            'seo_title' => 'What is MAC address in MAG devices?',
            'seo_keywords' => 'mac address, mag device, how to find mac address of mag',
            'seo_description' => 'What is MAC address in MAG devices?',
        ]);

        Post::create([
            'title' => 'How to setup IPTV on a MAG device ?​',
            'slug' => 'how-to-setup-iptv-on-a-mag-device',
            'visibility' => 1,
            'poster' => $link6,
            'content' => '<h2>An overview of MAG</h2><p>MAG boxes are some of the most powerful streaming media players. IPTV users choose them for their speed, simplicity, and excellent streaming performance. The user interface is simple and responsive, channel switching is quick and you receive all the features required to get the most out of your <strong>IPTV </strong>service.</p><p>If your Mad device does not allow you to type in m3u link, please get back to us with your MAC address, we will add it to our server.This tutorial will guide you through a simple and effective step of installation your&nbsp;Mag (250/254/256&hellip;).&nbsp;</p><p><br/><strong>Step 1:</strong> When the box is being loaded the main portal screen appears. After that click on &ldquo;settings&rdquo;, press remote button &ldquo;SETUP/SET&rdquo;.</p><p><img alt="" src="'.asset('images/blog/how-to-setup-iptv-on-a-mag-device/webp/1.webp').'" style="height:368px; width:900px"/></p><p><strong>Step 2:</strong> Then press on &ldquo;System settings&rdquo; and click on &ldquo;Servers&rdquo;.</p><p><img alt="" src="'.asset('images/blog/how-to-setup-iptv-on-a-mag-device/webp/2.webp').'" style="height:525px; width:1000px"/></p><p><strong>Step 3:</strong> Click on &lsquo;Servers&rsquo;</p><p><img alt="" src="'.asset('images/blog/how-to-setup-iptv-on-a-mag-device/webp/3.webp').'" style="height:502px; width:1000px"/></p><p><strong>Step 4: </strong>Choose and Press option &lsquo;Portals&rsquo;</p><p><img alt="" src="'.asset('images/blog/how-to-setup-iptv-on-a-mag-device/webp/4.webp').'" style="height:521px; width:1000px"/></p><p><strong>Step 5:</strong> In the &lsquo;Portal 1 name&rsquo; line enter a portal name and in the &lsquo;Portal 1 URL&rsquo; enter portal URL.</p><p><img alt="" src="'.asset('images/blog/how-to-setup-iptv-on-a-mag-device/webp/5.webp').'" style="height:459px; width:688px"/></p><p>Therefore for the activation of our <strong>IPTV </strong>subscription on your MAG box, you must send us with your order the MAC address found on the label behind the box, the activation is done entirely remotely, just after activation, we will send you a URL link that you have to put on your PORTAL, as in the photo below:</p><p><strong>Step 6</strong> &ndash; Finally when you complete select and click &lsquo;OK&rsquo; to save the changes.<br/><strong>Step&nbsp;7</strong> &ndash; Click &lsquo;EXIT&rsquo; on the remote control after the settings are being saved.<br/><strong>Step&nbsp;8</strong> &ndash; Consequently you have to reboot the box. Choose the option &lsquo;OK&rsquo; to make the changes applied.<br/><strong>Step&nbsp;9</strong> &ndash; Enjoy watching over than 8000 channels with HD quality worldwide.</p>',
            'seo_title' => 'How to setup IPTV on a MAG device ?​',
            'seo_keywords' => 'iptv, mag device, iptv on mag, iptv 12 months, iptv subscription',
            'seo_description' => 'how to setup my iptv subscription on mag device',
        ]);
    }
}
