<?php

namespace Database\Seeders;

use App\Models\ChannelList;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DinoChannelsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table("channel_lists")->truncate();
        $client = new \GuzzleHttp\Client();
        $response = $client->request('GET', "http://159.223.2.126:3001/categories");
        $categories = json_decode($response->getBody());
        for ( $i=0 ; $i < count($categories); $i++ ) {
            $category = $categories[$i];
            $catData = $this->getCategoryData($category->slug);
            ChannelList::create([
                'country' => $category->name,
                'data' => $catData->data
            ]);
            $this->command->info($category->name);
        }
    }
    
    function getCategoryData($slug) {
        $client = new \GuzzleHttp\Client();
        $response = $client->request('GET', "http://159.223.2.126:3001/category/".$slug);
        return json_decode($response->getBody());
    }
}
