<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateServicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('services', function (Blueprint $table) {
            $table->id();
            $table->integer('product_id');
            $table->integer('server_id')->default(0);
            $table->integer('subtype_id');
            $table->string('title');
            $table->string('price');
            $table->string('host')->nullable();
            $table->string('username')->nullable();
            $table->string('password')->nullable();
            $table->string('m3u')->nullable();
            $table->string('epg')->nullable();
            $table->text('enigma')->nullable();
            $table->string('mac_address')->nullable();
            $table->text('notes')->nullable();
            $table->timestamp('activation_date')->nullable();
            $table->timestamp('expiration_date')->nullable();
            $table->boolean('activated')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('services');
    }
}
