<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->integer('service_id');
            $table->integer('product_id');
            $table->string('ppl_customer_id');
            $table->string('ppl_transaction_id');
            $table->string('ppl_firstName');
            $table->string('ppl_lastName');
            $table->string('ppl_email');
            $table->string('ppl_country');
            $table->string('billing_email');
            $table->string('billing_name');
            $table->string('total');
            $table->boolean('adult')->default(false);
            $table->float('adult_price')->default(0);
            $table->boolean('vod')->default(false);
            $table->float('vod_price')->default(0);
            $table->boolean('prioritize')->default(false);
            $table->float('prioritize_price')->default(0);
            $table->boolean('paid');
            $table->boolean('sent')->default(false);
            $table->boolean('refunded')->default(false);
            $table->timestamp('payment_date')->nullable();
            $table->timestamps();
        });
    }    
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
