<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->integer('category_id');
            $table->string('title');
            $table->string('short_title');
            $table->string('period');
            $table->float('price');
            $table->float('old_price');
            $table->string('seo_title');
            $table->string('seo_keywords')->nullable();
            $table->string('seo_description')->nullable();
            $table->boolean('visibility')->default(0);
            $table->boolean('in_stock')->default(1);
            $table->boolean('hot')->default(0);
            $table->integer('views')->default(0);
            $table->integer('targeted_product');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
}
