<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    use HasFactory;

    protected $fillable = [
        'product_id',
        'server_id',
        'subtype_id',
        'title',
        'price',
        'host',
        'username',
        'password',
        'm3u',
        'epg',
        'mac_address',
        'enigma',
        'notes',
        'activation_date',
        'expiration_date',
        'activated'
    ];

    protected $dates = [
        'created_at',
        'updated_at',
        'activation_date',
        'expiration_date'
    ];

    public function product() {
        return $this->belongsTo(Product::class);
    }

    public function category() {
        return $this->product()->category();
    }
}