<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    protected $fillable = [
        'category_id',
        'title',
        'short_title',
        'period',
        'price',
        'old_price',
        'seo_title',
        'seo_keywords',
        'seo_description',
        'visibility',
        'in_stock',
        'hot',
        'targeted_product'
    ];
    
    public function orders() {
        return $this->hasMany(Order::class);
    }

    public function category() {
        return $this->belongsTo(Category::class);
    }
}