<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use HasFactory;

    protected $dates = [
        'created_at',
        'updated_at',
        'payment_date',
    ];

    protected $fillable = [
        'service_id',
        'product_id',
        'ppl_customer_id',
        'ppl_transaction_id',
        'ppl_firstName',
        'ppl_lastName',
        'ppl_email',
        'ppl_country',
        'billing_email',
        'billing_name',
        'total',
        'adult',
        'vod',
        'prioritize',
        'adult_price',
        'vod_price',
        'prioritize_price',
        'paid',
        'sent',
        'refunded',
        'payment_date',
    ];

    public function service() {
        return $this->belongsTo(Service::class);
    }

    public function product() {
        return $this->belongsTo(Product::class);
    }
}