<?php

namespace App\Mail;

use App\Models\Config;
use App\Models\Order;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SendInvoiceMail extends Mailable
{
    use Queueable, SerializesModels;




    public $order_id;

    public function __construct($order_id)
    {
        $this->order_id = $order_id;
    }
    
    public function build()
    {
        $order = Order::whereId($this->order_id)->first();
        $json["order_id"] = $order->id;
        $json["product_name"] = $order->product->period;
        $json["subtotal"] = $order->total;
        $json["vod"] = $order->vod;
        $json["vod_price"] = $order->vod_price;
        $json["adult"] = $order->adult;
        $json["adult_price"] = $order->adult_price;
        $json["prioritize"] = $order->prioritize;
        $json["prioritize_price"] = $order->prioritize_price;
        $data = base64_encode(json_encode($json));
        $url = route('pay_invoice', $data);
        return $this->subject($order->product->short_title.' [ Invoice Payment ]')
                    ->markdown('mails.send_invoice', [ 'url' => $url, 'order' => $order ]);
    }
}