<?php

namespace App\Mail;

use App\Models\Order;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SendExpiredMail extends Mailable
{
    use Queueable, SerializesModels;

    protected $order;
    protected $expiration_date;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($order, $expiration_date)
    {
        $this->order = $order;
        $this->order->expiration_date = $expiration_date;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('IPsubTV - RENEWING REMINDER')
                    ->markdown('mails.send_expiration', [ 'order' => $this->order ]);
    }
}
