<?php

namespace App\Jobs;

use App\Mail\SendExpiredMail;
use App\Models\Order;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Mail;

class SendExpiredEmailJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */

     protected $order;
     protected $expiration_date;

    public function __construct($order_id, $expiration_date)
    {
        $this->expiration_date = $expiration_date;
        $this->order = Order::whereId($order_id)->first();
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        // check if emails are existed;
        $emails_adds = [];
        if( isset($this->order->billing_email) ) $emails_adds[] = $this->order->billing_email;
        if( isset($this->order->ppl_email) ) $emails_adds[] = $this->order->ppl_email;

        // send email after 
        if( count($emails_adds) > 0 ) {
            Mail::to($emails_adds)->send(new SendExpiredMail($this->order, $this->expiration_date));
            Order::whereId($this->order->id)->update([ 'expired_email_sent' => true]);
        }
    }
}