<?php

namespace App\Http\Controllers;

use App\Mail\ContactMail;
use App\Models\Category;
use App\Models\ChannelList;
use App\Models\Device;
use App\Models\LegalPage;
use App\Models\Post;
use App\Models\Product;
use App\Models\Question;
use App\Models\Testimonial;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;

class HomeController extends Controller
{
    public function getCountryData($id) {
        return ChannelList::whereId($id)->first()->data;
    }

    public function home() {
        $categories = Category::all();



    

        $questions = Question::whereVisibility(1)->get();
        $testimonials = Testimonial::whereVisibility(1)->get();
        $posts = Post::whereVisibility(1)->take(8)->get();


        return view('home')->with(compact('categories', 'questions', 'testimonials', 'posts'));
    }

    public function contactus() {
        return view('contactus');
    }

    public function contactus_send(Request $request) {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email',
            'subject' => 'required',
            'message' => 'required',
            'h-captcha-response' => 'required'
        ]);
        if ($validator->fails()) {
            return back()->with('error', 'Message Not Sent!');
        }else {
            Mail::to('delivery@ipsubtv.com')->send(new ContactMail($request->message, $request->subject, $request->email));
            return back()->with('success', 'Message Sent Successfully!');
        }
    }

    public function product($slug)
    {
        $product = Product::whereRaw('slug = "'.$slug.'" and visibility = 1')->firstOrFail();
        $product->poster = $product->poster == '' ? asset('noposter.jpeg') : asset('storage/'.$product->poster);
        $tag = $product->tags;
        $related_products = Product::where('id', '!=', $product->id)->where('tags', 'LIKE', '%'.$tag.'%')->orderBy('views', 'desc')->get();
        $product->increment('views', 1);
        $devices = Device::all();
        return view('product')->with(compact('product', 'related_products', 'devices'));
    }

    public function category($id)
    {
        $category = Category::findOrFail($id);
        $title = $category->name;
        $products = $category->products()->whereVisibility('1')->get()->map(function($product) {
            $product->poster = $product->poster == '' ? asset('noposter.jpeg') : asset('storage/'.$product->poster);
            return $product;
        });
        return view('category')->with(compact('title', 'products'));
    }

    public function channels_list() {
        $list = ChannelList::all(['id', 'country'])->toArray();
        $firstCountry = ChannelList::first();
        $first_country = $firstCountry->country;
        $first_data = $firstCountry->data;
        return view('channels_list')->with(compact( 'list', 'first_country', 'first_data' ));
    }

    public function subscriptions() {
        $categories = Category::all();
        $title = 'Pricing';
        return view('subscriptions')->with(compact('categories', 'title'));
    }

    public function post($slug) {
        $post = Post::whereSlug($slug)->first();
        if(!$post) abort(404);
        return view('post')->with('post', $post);
    }

    public function setup() {
        $posts = Post::whereVisibility(1)->orderBy('created_at', 'desc')->get();
        return view('setup')->with('posts', $posts);
    }

    public function page($slug) {
        $page = LegalPage::whereSlug($slug)->first();
        if(!$page) abort(404);
        return view('post')->with('post', $page);
    }
}
