<?php

namespace App\Http\Controllers;

use App\Jobs\NewOrderJob;
use App\Models\Config;
use App\Models\Order;
use App\Models\Service;
use Carbon\Carbon;
use Gloudemans\Shoppingcart\Facades\Cart;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class CheckoutController extends Controller
{
    public function show() {
        $items = Cart::content();
        foreach( $items as $item ) {
            if( count($item->options) == 0 ) return redirect()->route('cart');
            $adult = $item->options->adult ? 1 : 0;
            $adult_price = $item->options->adult_price;

            $vod = $item->options->vod ? 1 : 0;
            $vod_price = $item->options->vod_price;

            $prioritize = $item->options->prioritize ? 1 : 0;
            $prioritize_price = $item->options->prioritize_price;

            $product_title = $item->name;
            break;
        }
        if(count($items) == 0) return redirect()->route('home');
        return view('checkout')->with(compact('adult', 'adult_price', 'vod', 'vod_price', 'prioritize', 'prioritize_price', 'product_title'));
    }

    public function checkout_bridge(Request $request) {
        $adult_price = $request->adult ? $this->getAddonPrice('adult_price') : 0;
        $vod_price = $request->vod ? $this->getAddonPrice('vod_price') : 0;
        $prioritize_price = $request->prioritize ? $this->getAddonPrice('prioritize_price') : 0;
        foreach( Cart::content() as $item ) {
            Cart::update($item->rowId, [
                'options' => [
                    'subtype_id' => (int) $request->subtype_id,
                    'mac_address' => $request->mac_address,
                    'notes' => $request->notes,
                    'adult' => (boolean) $request->adult,
                    'adult_price' => (float) $adult_price,
                    'vod' => (boolean) $request->vod,
                    'vod_price' => (float) $vod_price,
                    'prioritize' => (boolean) $request->prioritize,
                    'prioritize_price' => (float) $prioritize_price,
                ],
            ]);
        }
        return redirect()->route('checkout');
    }

    private function getAddonPrice($string) {
        return Config::whereName($string)->first()->value;
    }

    function getrandomelement($array) {
        $pos=rand(0,sizeof($array)-1);
        $res=$array[$pos];
        if (is_array($res)) return $this->getrandomelement($res);
        else return $res;
    }

    public function payment_ok(Request $request) {
        foreach( Cart::content() as $item ) {
            $cart_item = $item;
            break;
        }
        /**
         * CREATE NEW SERVICE;
        */
        $serviceData['product_id'] = $cart_item->model->id;
        $serviceData['title'] = $cart_item->model->short_title;
        $serviceData['price'] = $cart_item->model->price;
        $serviceData['subtype_id'] = $cart_item->options->subtype_id;
        $serviceData['mac_address'] = $cart_item->options->mac_address;
        $serviceData['notes'] = $cart_item->options->notes;
        $service = Service::create($serviceData);
        /**
         * CREATE NEW ORDER;
        */
        $orderData['service_id'] = $service->id;
        $orderData['product_id'] = $cart_item->model->id;       
        $orderData['ppl_customer_id'] = "";
        $orderData['ppl_transaction_id'] = "";
        $orderData['ppl_firstName'] = "";
        $orderData['ppl_lastName'] = "";
        $orderData['ppl_email'] = "";
        $orderData['ppl_country'] = "";
        $orderData['billing_name'] = $request->billing_name;
        $orderData['billing_email'] = $request->billing_email;
        $orderData['total'] = (float)Cart::subtotal() + (float)$cart_item->options->vod_price + (float)$cart_item->options->adult_price + (float)$cart_item->options->prioritize_price;
        $orderData['adult'] = $cart_item->options->adult;
        $orderData['adult_price'] = $cart_item->options->adult_price;
        $orderData['vod'] = $cart_item->options->vod;
        $orderData['vod_price'] = $cart_item->options->vod_price;
        $orderData['prioritize'] = $cart_item->options->prioritize;
        $orderData['prioritize_price'] = $cart_item->options->prioritize_price;
        $orderData['paid'] = false;
        $orderData['sent'] = false;
        $orderData['refunded'] = false;
        $order = Order::create($orderData);
        /**
         * SETUP CLOAKING;
        */
        $json["order_id"] = $order->id;
        $json["product_name"] = $order->product->period;
        $json["subtotal"] = (float) Cart::subtotal();
        $json["total"] = $order->total;
        $json["vod"] = $order->vod;
        $json["vod_price"] = $order->vod_price;
        $json["adult"] = $order->adult;
        $json["adult_price"] = $order->adult_price;
        $json["prioritize"] = $order->prioritize;
        $json["prioritize_price"] = $order->prioritize_price;
        Cart::destroy();
        $legal_website = Config::whereName('legal_website')->first()->value;
        return redirect($legal_website.'/checkout?data='.base64_encode(json_encode($json)));
    }

    public function complete_ref_payment($json) {
        $legal_website = Config::whereName('legal_website')->first()->value;
        $referer = str_replace("https://", "", $legal_website);
        $referer = str_replace("http://", "", $referer);
        $referer = str_replace("/", "", $referer);
        if( Str::contains(request()->headers->get('referer'), $referer) ) {
            $data = json_decode(base64_decode($json));
            $result = Order::whereId($data->order_id)->first()->update([
                'ppl_customer_id' => $data->customer_id,
                'ppl_transaction_id' => $data->transaction_id,
                'ppl_firstName' => $data->first_name,
                'ppl_lastName' => $data->last_name,
                'ppl_email' => $data->paypal_email,
                'ppl_country' => $data->country,
                'paid' => true,
                'payment_date' => Carbon::now(),
            ]);
            if($result == 1) {
                session()->put('order_received', $data->order_id);
                return redirect()->route('order_received');
            }
        }
        return redirect()->route('home');
    }
    
    public function order_received() {
        if( session()->has('order_received') ) {
            $order = Order::whereId(session()->get('order_received'))->with('service')->first();
            NewOrderJob::dispatch( $order->billing_email, $order->id);
            $order->service->processing = $order->service->activation_date != '' ? false : true;
            if(!$order->service->processing) {
                $order->service->expired = !$order->service->expiration_date->gt(Carbon::now());
            }else $order->service->expired = false;
            session()->forget('order_received');
            return view('order_received')->with('order', $order);
        }else return redirect()->route('home');
    }

    public function pay_invoice($data) {
        $d = json_decode(base64_decode($data));
        $legal_website = Config::whereName('legal_website')->first()->value;
        $paid = Order::whereId($d->order_id)->first()->paid;

        return view('pay_invoice')->with(compact('legal_website', 'paid', 'data'));
        
        // return view('pay_invoice')->with('url', $legal_website.'/checkout?data='.$data);
    }
}