<?php

namespace App\Http\Controllers;

use App\Models\Application;
use App\Models\Config;
use App\Models\Device;
use App\Models\Product;
use App\Models\Subtype;
use Illuminate\Http\Request;
use Gloudemans\Shoppingcart\Facades\Cart;

class CartController extends Controller
{
    public function show(Request $request) {
        if( $request->id !== null ) $this->store($request);
        $items = Cart::content();
        $subtypes = Subtype::select(['id', 'title'])->get();
        $adult_enabled = Config::whereName('adult_enabled')->first()->value;
        $adult_price = Config::whereName('adult_price')->first()->value;
        $vod_enabled = Config::whereName('vod_enabled')->first()->value;
        $vod_price = Config::whereName('vod_price')->first()->value;
        $prioritize_enabled = Config::whereName('prioritize_enabled')->first()->value;
        $prioritize_price = Config::whereName('prioritize_price')->first()->value;
        return view('cart')->with(compact(
            'items',
            'subtypes',
            'adult_enabled',
            'adult_price',
            'vod_enabled',
            'vod_price',
            'prioritize_enabled',
            'prioritize_price'
        ));
    }

    public function store(Request $request) {
        Cart::destroy();
        $product = Product::whereId($request->id)->firstOrFail();
        Cart::add($product->id, $product->period, 1, $product->price)->associate($product);
        return redirect()->route('cart')->with('success', 'Added To Cart Successfully!');
    }

    public function destroy() {
        Cart::destroy();
        return view('cart')->with('products', []);
    }

    public function remove($rowId) {
        Cart::remove($rowId);
        return redirect()->route('cart')->with('success', 'Removed From Cart Successfully!');
    }

    public function update_qty(Request $request) {
        Cart::update($request->rowId, $request->qty);
        return redirect()->route('cart')->with('success', 'Quantity Updated Successfully!');
    }
}