<?php

namespace App\Console\Commands;

use App\Jobs\SendExpiredEmailJob;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class SendExpiredMails extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'expired:send';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send renewing mails to the expired subscriptions.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $orders = DB::table('orders')
                        ->where('payment_date', 'NOT LIKE', NULL)
                        ->join('services', 'services.id', '=', 'orders.service_id')
                        ->whereDate( 'expiration_date', '>', now())
                        ->whereDate( 'expiration_date', '<', now()->addDays(60))
                        ->select(['billing_email', 'ppl_email', 'expiration_date', 'orders.id', 'expired_email_sent'])
                        ->get()->map(function($d) {
                            if( strtolower($d->billing_email) == strtolower($d->ppl_email) ) {
                                unset($d->billing_email);
                            }

                            $d->result = \Carbon\Carbon::now()->diffForHumans($d->expiration_date, false);

                            return $d;
                        });


        foreach( $orders as $order ) {
            if($order->expired_email_sent == 0) {
                SendExpiredEmailJob::dispatch($order->id, $order->expiration_date);
                $this->info("Order N° : ".$order->id." ==> Queued.");
            }
        }
        

        return "Sent";
    }
}
