<?php $__env->startSection('title', 'Categories'); ?>
<?php $__env->startSection('content'); ?>
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
  <a href="<?php echo e(route('admin.category_insert')); ?>" class="goback btn btn-danger"><i class="fa fa-plus"></i>Insert Category</a>
</div>
<div class="card card-default color-palette-box">
    <?php if( session()->has('success') ): ?>
    <span class="badge bg-success"> <?php echo e(session()->get('success')); ?> </span>
    <?php endif; ?>
    <div class="card-body">
        <?php if(count($categories) > 0): ?>
        <form method="POST" action="<?php echo e(route('admin.categories_update')); ?>">
            <?php echo csrf_field(); ?>
            <table class="table">
                <thead>
                    <tr>
                        <th scope="col"></th>
                        <th scope="col">Name</th>
                        <th scope="col">Active</th>
                        <th scope="col"></th>
                    </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="product-table">
                    <td><?php echo e($category->id); ?><input type="hidden" name="id[]" value="<?php echo e($category->id); ?>"></td>
                    <td><input class="form-control" type="text" name="name[]" value="<?php echo e($category->name); ?>"></td>
                    <td>
                      <select name="active[]">
                        <option value="1" <?php echo e($category->active == 1 ? 'selected' : ''); ?>>YES</option>
                        <option value="0" <?php echo e($category->active == 0 ? 'selected' : ''); ?>>NO</option>
                      </select>
                    </td>
                    <td class="actions">
                        <a class="remove_category" data-id="<?php echo e($category->id); ?>" href="#"><i class="edit fa fa-trash"></i></a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <button class="btn btn-primary">Update</button>
        <form>
        <?php else: ?>
       <h3>No Categories</h3>
       <?php endif; ?>
    </div>
 </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_js'); ?>
<script>
  $(document).ready(() => {
      $('.remove_category').on('click', function(e) {
        e.preventDefault()
        var confirmA = confirm('Delete Type ?')
        var category_id = $(this).attr('data-id')
        var link = "<?php echo e(route('admin.category_delete', 0)); ?>"
        if(confirmA) {
          window.location.href = link.replace('/0', '/'+category_id)
        }
      });
  })
</script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_css'); ?>
    <style>
      td.title {
        background: #eee;
        width: 100%;
        padding: 7px;
        display: inline-block;
        color: #333;
      }
    </style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.adminapp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\fullsubtv.com\resources\views/admin/categories.blade.php ENDPATH**/ ?>