<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" xmlns="http://www.w3.org/1999/xhtml" itemscope itemtype="http://schema.org/WebPage">
    <head prefix="og: http://ogp.me/ns# fb: http://ogp.me/ns/fb# article: http://ogp.me/ns/article#">
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" >
        <link rel="profile" href="http://gmpg.org/xfn/11">
        <link rel="shortcut icon" href="<?php echo e(asset('storage/'.\App\Models\Config::whereName('favicon')->first()->value)); ?>">
        <meta name='robots' content='index, follow, max-image-preview:large, max-snippet:-1, max-video-preview:-1' />
        <meta name="format-detection" content="telephone=no">
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link rel="canonical" href="<?php echo e(url()->full()); ?>" />
        <meta name="description" content="<?php echo $__env->yieldContent('description'); ?>">
        <title><?php echo $__env->yieldContent('title'); ?></title>
        <meta property="og:site_name" content="<?php echo $__env->yieldContent('title'); ?>">
        <meta property="og:url" content="<?php echo e(url()->full()); ?>">
        <meta property="og:title" content="<?php echo $__env->yieldContent('title'); ?>">
        <meta property="og:type" content="website">
        <meta property="og:description" content="<?php echo $__env->yieldContent('description'); ?>">
        <meta name="twitter:card" content="summary_large_image">
        <meta name="twitter:title" content="<?php echo $__env->yieldContent('title'); ?>">
        <meta name="twitter:description" content="<?php echo $__env->yieldContent('description'); ?>">
        
        <?php
            $disable_tools = \App\Models\Config::whereName('disable_tools')->first()->value
        ?>

        <?php if( $disable_tools == 1 ): ?>
        <style>
            * {
                -webkit-user-select: none; /* Safari */
                -ms-user-select: none; /* IE 10 and IE 11 */
                user-select: none; /* Standard syntax */
            }
        </style>
        <?php endif; ?>

        <?php
        $host = parse_url(env('APP_URL'))['host'];
        ?>
        <script type="application/ld+json">
            {
                "@context":"https://schema.org",
                "@graph":[
                   {
                      "@type":"WebPage",
                      "@id":"<?php echo e(url()->full()); ?>",
                      "url":"<?php echo e(url()->full()); ?>",
                      "name":"<?php echo $__env->yieldContent('title'); ?>",
                      "isPartOf":{
                         "@id":"https://<?php echo e($host); ?>/#website"
                      },
                      "datePublished":"2022-06-26T12:02:19+00:00",
                      "dateModified":"2022-09-04T18:23:07+00:00",
                      "description":"<?php echo $__env->yieldContent('description'); ?>",
                      "breadcrumb":{
                         "@id":"<?php echo e(url()->full()); ?>/#breadcrumb"
                      },
                      "inLanguage":"en-US",
                      "potentialAction":[
                         {
                            "@type":"ReadAction",
                            "target":[
                               "<?php echo e(url()->full()); ?>"
                            ]
                         }
                      ]
                   },
                   {
                      "@type":"BreadcrumbList",
                      "@id":"<?php echo e(url()->full()); ?>/#breadcrumb",
                      "itemListElement":[
                         {
                            "@type":"ListItem",
                            "position":1,
                            "name":"Home",
                            "item":"https://<?php echo e($host); ?>/"
                         },
                         {
                            "@type":"ListItem",
                            "position":2,
                            "name":"Channels"
                         }
                      ]
                   },
                   {
                      "@type":"WebSite",
                      "@id":"https://<?php echo e($host); ?>/#website",
                      "url":"https://<?php echo e($host); ?>/",
                      "name":"<?php echo e(config('app.name')); ?>",
                      "description":"<?php echo e(\App\Models\Config::whereName('seo_description')->first()->value); ?>",
                      "publisher":{
                         "@id":"https://<?php echo e($host); ?>/#organization"
                      },
                      "potentialAction":[
                         {
                            "@type":"SearchAction",
                            "target":{
                               "@type":"EntryPoint",
                               "urlTemplate":"https://<?php echo e($host); ?>/?s={search_term_string}"
                            },
                            "query-input":"required name=search_term_string"
                         }
                      ],
                      "inLanguage":"en-US"
                   },
                   {
                      "@type":"Organization",
                      "@id":"https://<?php echo e($host); ?>/#organization",
                      "name":"<?php echo e(config('app.name')); ?> LTD",
                      "url":"https://<?php echo e($host); ?>/",
                      "logo":{
                         "@type":"ImageObject",
                         "inLanguage":"en-US",
                         "@id":"https://<?php echo e($host); ?>/#/schema/logo/image/",
                         "url":"<?php echo e(asset('storage/'.\App\Models\Config::whereName('black_logo')->first()->value)); ?>",
                         "contentUrl":"<?php echo e(asset('storage/'.\App\Models\Config::whereName('white_logo')->first()->value)); ?>",
                         "width":300,
                         "height":117,
                         "caption":"<?php echo e(config('app.name')); ?> LTD"
                      },
                      "image":{
                         "@id":"https://<?php echo e($host); ?>/#/schema/logo/image/"
                      }
                   }
                ]
             }
        </script>
        <style>
           <?php if( env('APP_ENV') == 'production' ): ?>
           <?php echo $__env->make('layouts.inc.css.app_min', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
           <?php else: ?>
           <?php echo $__env->make('layouts.inc.css.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
           <?php endif; ?>
           body {
            background : <?php echo e(App\Models\Config::whereName('background_color')->first()->value); ?>

           }
        </style>
        <?php echo $__env->yieldContent('extra_css'); ?>
        <?php if( \App\Models\Config::whereName('gads_tracking_enabled')->first()->value == 1 ): ?>            
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(\App\Models\Config::whereName('gads_tracking_tag')->first()->value); ?>"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());
            gtag('config', "<?php echo e(\App\Models\Config::whereName('gads_tracking_tag')->first()->value); ?>");
        </script>
        <?php endif; ?>

        <!-- Meta Pixel Code -->
        <script>
        !function(f,b,e,v,n,t,s)
        {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
        n.callMethod.apply(n,arguments):n.queue.push(arguments)};
        if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
        n.queue=[];t=b.createElement(e);t.async=!0;
        t.src=v;s=b.getElementsByTagName(e)[0];
        s.parentNode.insertBefore(t,s)}(window, document,'script',
        'https://connect.facebook.net/en_US/fbevents.js');
        fbq('init', '754509137265569');
        fbq('track', 'PageView');
        </script>
        <noscript><img height="1" width="1" style="display:none"
        src="https://www.facebook.com/tr?id=754509137265569&ev=PageView&noscript=1"
        /></noscript>
        <!-- End Meta Pixel Code -->
        <noscript><h3> You must have JavaScript enabled in order to use this order form. Please enable JavaScript and then reload this page in order to continue. </h3> </noscript>
    </head>
    <body>
        <span id="toTop"><i class="fa fa-arrow-up"></i></span>
        <div id="header">
            <?php if( App\Models\Config::whereName('top_message_allowed')->first()->value == 1 && false): ?>
            <div class="top-message">
                <?php echo e(App\Models\Config::whereName('top_message')->first()->value); ?>

            </div>
            <?php endif; ?>
            <nav class="navbar navbar-expand-lg">
                <div class="container">
                    <a id="logo" class="nav-brand" href="<?php echo e(route('home')); ?>">
                        <img width="150" height="39" alt="<?php echo e(config('app.name').' - '.\App\Models\Config::whereName('website_description')->first()->value); ?>" src="<?php echo e(asset('storage/'.\App\Models\Config::whereName('white_logo')->first()->value)); ?>">
                    </a>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"><i class="fa fa-bars" aria-hidden="true"></i></span>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav top-menu me-auto mb-2 mb-lg-0">
                            <?php if( App\Models\Config::whereName('trial_allowed')->first()->value == 1 ): ?>
                            <li><a class="nav-item" target="_blank" href="<?php echo e(route('wtsp').'?text=Please I Wanna Try The Server Before I Buy For '.config('app.url')); ?>">
                                Free Test
                            </a></li>
                            <?php endif; ?>
                            <li class="pricing">
                                <a class="nav-item" href="<?php echo e(Route::currentRouteName() == 'home' ? '#subscribe' : route('subscriptions')); ?>">
                                    pricing
                                </a>
                            </li>
                            <li><a class="nav-item" href="<?php echo e(route('how_to_install')); ?>">Tutorials</a></li>
                            <li><a class="nav-item" href="<?php echo e(route('channels_list')); ?>">Channels</a></li>
                            <li><a class="nav-item" href="<?php echo e(route('contactus')); ?>">Contact Us</a></li>
                        </ul>
                        <div class="top-right-menu">
                            <ul>
                                <li>
                                    <div class="cta_btn">
                                        <a class="order_now_cta" href="<?php echo e(Route::currentRouteName() == 'home' ? '#subscribe' : route('subscriptions')); ?>"> Order Now </a>
                                     </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </nav>
        </div>
        <?php echo $__env->yieldContent('content'); ?>
        <footer>
            <div class="container">
                <div class="row top_s">
                    <div class="about_us">
                        <div class="row">
                            <div class="col-md-3 links">
                                <a class="footer_logo" href="<?php echo e(route('home')); ?>">
                                    <img width="90" height="39" alt="<?php echo e(\App\Models\Config::whereName('about_us')->first()->value); ?>" 
                                    src="<?php echo e(asset('storage/'.\App\Models\Config::whereName('white_logo')->first()->value)); ?>">
                                </a>
                            </div>
                            <div class="col-md-9">
                                <div class="links top_l">
                                    <a href="<?php echo e(route('channels_list')); ?>" class="hvr-underline-from-center">channels list</a>
                                    <a href="<?php echo e(route('subscriptions')); ?>" class="hvr-underline-from-center">subscriptions</a>
                                    <a href="<?php echo e(route('faq')); ?>" class="hvr-underline-from-center">FAQ</a>
                                    <a href="<?php echo e(route('how_to_install')); ?>" class="hvr-underline-from-center">how to install</a>
                                    <a href="<?php echo e(route('contactus')); ?>" class="hvr-underline-from-center">contact us</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="links pages_menu">
                        <?php $__currentLoopData = \App\Models\LegalPage::whereVisibility(1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e(route('page', $page->slug)); ?>" class="hvr-underline-from-center"><?php echo e($page->title); ?></a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
            <div class="_footer">
                <span>
                    All Rights Are Reserved To <span class="colored"><?php echo e(config('app.name')); ?></span> <i class="fa fa-copyright" aria-hidden="true"></i> <?php echo e(\Carbon\Carbon::now()->year); ?>

                </span>
                <img width="200" height="auto" src="<?php echo e(asset('images/cards.webp')); ?>" alt="payment gateways">
            </div>
        </footer>
        <?php if( \App\Models\Config::whereName('gtag')->first()->value ): ?>
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(\App\Models\Config::whereName('gtag')->first()->value); ?>"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag() {
                dataLayer.push(arguments);
            }
            gtag('js', new Date());
            gtag('config', "<?php echo e(\App\Models\Config::whereName('gtag')->first()->value); ?>");
        </script>
        <?php endif; ?>
        <script>
        <?php if( env('APP_ENV') == 'production' ): ?>
        <?php echo $__env->make('layouts.inc.js.app_min', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php else: ?>
        <?php echo $__env->make('layouts.inc.js.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>

        <?php if( $disable_tools == 1 ): ?>
        <?php echo $__env->make('layouts.inc.js.disable_tools_min', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        </script>
        <?php echo $__env->yieldContent('extra_js'); ?>
        
    </body>
</html>
<?php /**PATH /var/www/ultrasubtv.com/resources/views/layouts/app.blade.php ENDPATH**/ ?>