<?php $__env->startSection('title', $title); ?>
<?php $__env->startSection('extra_css'); ?>
<link href="/vd/sweetalert2/dist/sweetalert2.min.css" rel="stylesheet" type="text/css"/>
<script src="/vd/sweetalert2/dist/sweetalert2.min.js" type="text/javascript"></script>
<style>
span.badge.bg-success {
    padding: 5px 11px;
}
span.badge.bg-warning {
    padding: 3px 16px;
    font-weight: 600;
    font-size: 13px;
}
.table_td span.badge.bg-warning, .table_td span.badge.bg-success {
    border-radius: 13px!important;
    padding: 2px 9px;
    text-transform: uppercase
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="card card-default color-palette-box">
    <div class="card-body table-responsive">
        <?php if($orders->count() > 0): ?>
        <form action="<?php echo e(route('admin.orders_filter')); ?>" id="filter_orders" method="POST">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="col-md-3">
                    <?php
                        $search_type = isset($search_type) ? $search_type : '';
                        $search_input = isset($search_input) ? $search_input : '';
                    ?>
                    <label for="search_type">TYPE</label>
                    <select name="search_type">
                        <option value="uuid" <?php echo e($search_type == 'uuid' ? 'selected' : ''); ?>>uuid</option>
                        <option value="id" <?php echo e($search_type == 'id' ? 'selected' : ''); ?>>Order ID</option>
                        <option value="billing_email" <?php echo e($search_type == 'billing_email' ? 'selected' : ''); ?>>Email Address</option>
                        <option value="transaction_id" <?php echo e($search_type == 'transaction_id' ? 'selected' : ''); ?>>Transaction ID</option>
                        <option value="customer_id" <?php echo e($search_type == 'customer_id' ? 'selected' : ''); ?>>Customer ID</option>
                        <option value="ppl_email" <?php echo e($search_type == 'ppl_email' ? 'selected' : ''); ?>>Paypal Email Address</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label for="search_input">INPUT</label>
                    <input class="form-control" type="text" name="search_input" placeholder="Search Input" value="<?php echo e($search_input); ?>">
                </div>
                <div class="row">
                    <button class="mt-3 btn btn-success" type="submit">Filter</button>
                </div>
            </div>
        </form>
        <table class="table">
            <thead>
                <tr>
                    <th>id</th>
                    <th>time</th>
                    <th>gateway</th>
                    <th>server</th>
                    <th>email</th>
                    <th>refunded</th>
                    <th>sent</th>
                    <th>total</th>
                    <th>actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr order-id="<?php echo e($order->id); ?>">
                    <th>
                        <div class="table_td">
                            #<?php echo e($order->id); ?>

                        </div>
                    </th>
                    <th>
                        <div class="table_td vertical">
                            <?php
                            $human_date = \Carbon\Carbon::parse(strtolower($title) == 'orders' ? $order->payment_date : $order->created_at);
                            ?>
                            <span class="badge d-block mb-1 bg-dark"><?php echo e($human_date->diffForhumans()); ?></span>
                            <span class="badge d-block bg-dark"><?php echo e($order->date); ?></span>
                        </div>
                    </th>
                    <th class="customer">
                        <div class="table_td">
                            <?php echo e($order->gateway); ?>

                        </div>
                    </th>
                    <th class="customer">
                        <div class="table_td">
                            <span class="badge bg-success">
                                <?php echo e($order->product->cnumber->category->name); ?>

                            </span>
                        </div>
                    </th>
                    <th class="customer">
                        <div class="table_td">
                            <?php echo e($order->billing_email); ?>

                        </div>
                    </th>
                    <th>
                        <div class="table_td">
                            <span class="badge bg-<?php echo e($order->refunded ? 'success' : 'warning'); ?>">
                            <?php echo e($order->refunded ? 'yes' : 'No'); ?>

                            </span>
                        </div>
                    </th>
                    <th>
                        <div class="table_td">
                            <span class="badge bg-<?php echo e($order->sent ? 'success' : 'warning'); ?>">
                                <?php echo e($order->sent ? 'yes' : 'Not Yet'); ?>

                                </span>
                        </div>
                    </th>
                    <th>
                        <div class="table_td">
                            <?php echo e($order->total); ?> <?php echo e($order->currency->symbol); ?>

                        </div>
                    </th>
                    <th class="actions">
                        <div class="table_td">
                            <?php if( strtolower($title) == 'orders' ): ?>
                            <a style="margin-right: 7px" href="<?php echo e(route('admin.order', $order->id)); ?>"><i class="fa fa-eye"></i></a>
                            <?php else: ?>
                            <a style="margin-right: 7px" href="<?php echo e(route('admin.invoice', $order->id)); ?>"><i class="fa fa-eye"></i></a>
                            <?php endif; ?>
                            <a class="remove_order" data-url="<?php echo e(route('admin.order_delete', $order->id)); ?>" href="#"><i class="fa fa-trash"></i></a>
                        </div>
                    </th>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <?php echo $orders->links(); ?>

        <?php else: ?>
        <span>You Have No <?php echo e($title); ?></span>
        <?php endif; ?>
    </div>
 </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_js'); ?>
<script>
    $(document).ready(function() {
        $('a.remove_order').on('click', function(e) {
            e.preventDefault()
            var confirm = window.confirm('Sure ?');
            if(confirm) {
                window.location.href = $(this).data('url')
            }
        })
    })
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.adminapp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\raciptv.com\resources\views/admin/orders.blade.php ENDPATH**/ ?>