<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Confirmation</title>
    <style>
        /* Add your custom CSS styles here */
        body {
            font-family: Arial, sans-serif;
            background-color: #fff;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 600px;
            margin: 25px auto;
            padding: 20px;
            background-color: #f1f0f0;
            border-radius: 10px;
        }

        h1 {
            color: #333;
        }

        p {
            font-size: 14px;
            line-height: 1.6;
            color: #666;
            font-weight: 500;
            font-family: monospace;
            margin-top: 8px!important;
            margin-bottom: 8px!important;
        }

        .order-details {
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        table, th, td {
            border: 1px solid #e2dcdc;
        }

        th, td {
            padding: 10px;
            text-align: left;
        }

        th {
            background-color: #183D3D;
            color: white
        }

        .thank-you {
            text-align: center;
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 style="font-size: 17px">Order Confirmation</h1>
        <p  style="font-size: 14px">Dear <b style="text-transform: capitalize">{{$order->billing_name}}</b>,</p>
        <p style="font-size: 14px">Thank you for your order. We are excited to inform you that your order has been successfully placed.</p>

        <div class="order-details">
            <h2 style="font-size: 15px">Order Details :</h2>
            <table>
                <thead>
                    <tr>
                        <th style="text-align: center">
                            ID
                        </th>
                        <th style="text-align: center">
                            Payment gateway
                        </th>
                        <th style="text-align: center">
                            Total paid
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td style="font-family: monospace;font-weight: 800;font-size: 16px;text-align: center;color: #1b1b1c">
                            #{{$order->id}}
                        </td>
                        <td style="font-family: monospace;font-weight: 800;font-size: 16px;text-align: center;color: #1b1b1c">
                            {{$order->gateway}}
                        </td>
                        <td style="font-family: monospace;font-weight: 800;font-size: 16px;text-align: center;color: #1b1b1c">
                            {{$order->total.' '.$order->currency->code}}
                        </td>
                    </tr>
                </tbody>
            </table>
            <table>
                <thead>
                    <tr>
                        <th style="text-align: center">
                            Service
                        </th>
                        <th style="text-align: center">
                            Email address
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td style="font-family: monospace;font-weight: 800;font-size: 16px;text-align: center;color: #1b1b1c">
                            {{$order->product->short_title}}
                        </td>
                        <td style="text-align: center;color: #1b1b1c">
                            <a href="#" style="font-size: 16px;font-weight: 800;font-family: monospace;text-decoration: none;color: #333!important;font-size: 16px">{{ $order->billing_email }}</a>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>

        <p style="font-size: 14px">For any questions or concerns, please contact our customer support in our <a style="text-decoration: none;color: green" href="{{route('contactus')}}">Contact Page</a>.</p>

        <div class="thank-you">
            <p style="font-size: 14px">Thank you for choosing <a style="text-decoration: none;color: #333!important" href="{{config('app.url')}}">{{config('app.name')}}</a></p>
        </div>
    </div>
</body>
</html>












