@extends('layouts.app')
@section('title', config('app.name').' - '.$title)
@section('description', $description)
@section('content')
<div class="container">
    <div id="blog">
        <h1></i> HOW TO INSTALL ?</h1>
        <p class="note">* click on the device or application you want to setup iptv on.</p>
        <ul class="titles">
            @foreach ($posts as $post)
            <li data-id="{{$post->id}}" @if( $p !== null && $p->id == $post->id ) class="active" @endif>
                <img width="90" height="90" src="{{asset('storage/'.$post->icon)}}" alt="">
                {{$post->title}}
            </li>
            @endforeach
        </ul>
        @if($p)
        <div class="content" style="display: block">{!! $p->content !!}</div>
        @else
        <div class="content"></div>
        @endif
    </div>
</div>
@endsection
@section('extra_css')
<style>
div#category {
    padding: 39px 0;
}
div#category>h1 {
    font-size: 33px;
    font-weight: 800;
    color: #333;
    text-align: center;
    margin: 0;
    padding-bottom: 23px;
    padding-top: 9px;
}
</style>
@endsection
@section('extra_js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/axios/1.2.1/axios.min.js" integrity="sha512-zJYu9ICC+mWF3+dJ4QC34N9RA0OVS1XtPbnf6oXlvGrLGNB8egsEzu/5wgG90I61hOOKvcywoLzwNmPqGAdATA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>
    var post_url = '{{route('getPostData', 0)}}'

    @if( env('APP_ENV') == 'production' )
    post_url = post_url.replace('http://', 'https://')
    @endif

    $(document).ready(function() {
        $('ul.titles li').on('click', function() {
            if( !$(this).hasClass('active') ) {
                $('#blog .content').html('<i class="fa fa-circle-o-notch fa-spin fa-3x fa-fw"></i>')
                $(this).siblings().removeClass('active')
                post_id = $(this).attr('data-id')
                if( !$(this).hasClass('active') ) {
                    axios.get(post_url.replace('/0', '/' + post_id)).then(data => data.data)
                    .then(data => {
                        $('#blog .content').css('display', 'block')
                        $("#blog .content").get(0).scrollIntoView({behavior: 'smooth'});
                        setTimeout(() => {
                            $('#blog .content').html(data)
                        }, 1000)
                    })
                }
                $(this).addClass('active')
            }
        })
    })
</script>
@endsection