@extends('layouts.adminapp')
@section('title', 'Subscription Types')
@section('content')
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
  <a href="{{route('admin.subtype_insert')}}" class="goback btn btn-danger"><i class="fa fa-plus"></i>Insert New SubType</a>
</div>
<div class="card card-default color-palette-box">
    @if( session()->has('success') )
    <span class="badge bg-success"> {{session()->get('success')}} </span>
    @endif
    <div class="card-body">
        @if (count($subtypes) > 0)
        <form method="POST" action="{{route('admin.subtypes_update')}}">
            @csrf
            <table class="table">
                <tbody>
                @foreach($subtypes as $subtype)
                <tr class="product-table">
                    <td>#{{$subtype->id}}</td>
                    <td><input class="form-control" type="text" name="title[]" value="{{$subtype->title}}"></td>
                    <td><input type="hidden" name="id[]" value="{{$subtype->id}}"></td>
                </tr>
                @endforeach
                </tbody>
            </table>
            <button class="btn btn-primary">Update</button>
        <form>
        @else
       <h3>No Categories</h3>
       @endif
    </div>
 </div>
@endsection
@section('extra_js')
<script>
  $(document).ready(() => {
      $('.remove_category').on('click', function(e) {
        e.preventDefault()
        var confirmA = confirm('Delete Type ?')
        var category_id = $(this).attr('data-id')
        var link = "{{route('admin.category_delete', 0)}}"
        if(confirmA) {
          window.location.href = link.replace('/0', '/'+category_id)
        }
      });
  })
</script>
@endsection
@section('extra_css')
    <style>
      td.title {
        background: #eee;
        width: 100%;
        padding: 7px;
        display: inline-block;
        color: #333;
      }
    </style>
@endsection