@extends('layouts.adminapp')
@section('title', 'Servers')
@section('content')
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
  <a href="{{route('admin.server_insert')}}" class="goback btn btn-danger"><i class="fa fa-plus"></i>Insert New Server</a>
</div>
<div class="card card-default color-palette-box">
    @if( session()->has('success') )
    <span class="badge bg-success"> {{session()->get('success')}} </span>
    @endif
    <div class="card-body">
        @if (count($servers) > 0)
        <form method="POST" action="{{route('admin.servers_update')}}">
            @csrf
            <table class="table">
              <thead>
                <tr>
                    <th>id</th>
                    <th>name</th>
                    <th>line</th>
                    <th>mag</th>
                    <th></th>
                </tr>
            </thead>
                <tbody>
                @foreach($servers as $server)
                <tr class="product-table">
                    <td>#{{$server->id}}<input type="hidden" name="id[]" value="{{$server->id}}"></td>
                    <td><input class="form-control" type="text" name="name[]" value="{{$server->name}}"></td>
                    <td><input class="form-control" type="text" name="line[]" value="{{$server->default_line}}"></td>
                    <td><input class="form-control" type="text" name="mag[]" value="{{$server->default_mag}}"></td>
                    <td>
                      <div class="table_td">
                        <a class="remove_server" data-url="{{route('admin.server_delete', $server->id)}}" href="#"><i class="fa fa-trash"></i></a>
                      </div>
                    </td>
                </tr>
                @endforeach
                </tbody>
            </table>
            <button class="btn btn-primary">Update</button>
        <form>
        @else
       <h3>No Categories</h3>
       @endif
    </div>
 </div>
@endsection
@section('extra_js')
<script>
    $(document).ready(function() {
        $('a.remove_server').on('click', function(e) {
          e.preventDefault()
            var confirm = window.confirm('Sure ?');
            if(confirm) {
                window.location.href = $(this).data('url')
            }
        })
    })
</script>
@endsection
@section('extra_css')
    <style>
      td.title {
        background: #eee;
        width: 100%;
        padding: 7px;
        display: inline-block;
        color: #333;
      }
      a.remove_server {
        background: red;
        color: white;
        width: 32px;
        height: 32px;
        text-align: center;
        padding: 4px;
        border-radius: 50%;
        font-size: 17px;
      }
      a.remove_server:hover {
        background: rgb(196, 0, 0);
        transition: 0.3s
      }
    </style>
@endsection