@extends('layouts.adminapp')
@section('title', 'Questions')
@section('content')
<div class="form-head d-flex mb-3  mb-lg-5 align-items-start">
  <a href="{{route('admin.questions_insert')}}" class="goback btn btn-danger"><i class="fa fa-plus"></i>Insert Question</a>
</div>
<div class="card card-default color-palette-box">
    @if( session()->has('success') )
    <span class="badge bg-success"> {{session()->get('success')}} </span>
    @endif
    <div class="card-body table-responsive">
       @if (count($questions) > 0)
       <table class="table">
        <thead>
          <tr>
            <th scope="col"></th>
            <th scope="col">Question</th>
            <th scope="col">Visibility</th>
            <th scope="col">Creation Date</th>
            <th scope="col"></th>
          </tr>
        </thead>
        <tbody>
        @foreach($questions as $question)
          <tr class="questions-table">
            <td>{{$question->id}}</td>
            <td>{{$question->question }}</td>
            <td>
              <span class="badge bg-{{$question->visibility == '1' ? 'success' : 'warning'}}">
                {{$question->visibility == '1' ? 'Visible' : 'Draft'}}
              </span>
            </td>
            <td>{{$question->created_at}}</td>
            <td class="actions">
              <a href="{{route('admin.questions_edit', $question->id)}}"><i class="edit fa fa-pencil"></i></a>
              <a class="remove_question" data-id="{{$question->id}}" href="#"><i class="edit fa fa-trash"></i></a>
            </td>
          </tr>
        @endforeach
        </tbody>
      </table>
       @else
       <h3>No Questions</h3>
       @endif
    </div>
 </div>
@endsection
@section('extra_js')
<script>
$('.remove_question').on('click', function(e) {
        e.preventDefault()
        var confirmA = confirm('Delete The Question ?')
        var question_id = $(this).attr('data-id')
        var link = "{{route('admin.questions_delete', 0)}}"
        if(confirmA) {
          window.location.href = link.replace('/0', '/'+question_id)
        }
      });
</script>
@endsection

@section('extra_css')
    <style>
    tr.questions-table span.badge {
        padding: 4px;
        text-transform: uppercase;
        font-size: 11px;
    }
    </style>
@endsection