<?php $__env->startSection('title', 'Origins'); ?>
<?php $__env->startSection('content'); ?>
<div class="form-head">
   <a href="<?php echo e(route('admin.origin_insert')); ?>" class="goback btn btn-danger"><i class="fa fa-plus"></i>New Origin</a>
</div>
<div class="card card-default color-palette-box">
   <div class="card-body">
      <div class="table-responsive">
         <?php if(count($origins) > 0): ?>
         <table class="table" width="100%">
            <thead>
               <tr>
                  <th scope="col"></th>
                  <th scope="col">name</th>
                  <th scope="col">url</th>
                  <th scope="col">status</th>
                  <th scope="col">creation date</th>
                  <th scope="col">actions</th>
               </tr>
            </thead>
            <tbody>
               <?php $__currentLoopData = $origins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $origin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
               <tr class="product-table">
                  <td><?php echo e($origin->id); ?></td>
                  <td><?php echo e($origin->name); ?></td>
                  <td><?php echo e($origin->url); ?></td>
                  <td>
                     <span class="badge bg-<?php echo e($origin->active == '1' ? 'success' : 'warning'); ?>">
                        <?php echo e($origin->active == '1' ? 'Active' : 'Not Active'); ?>

                     </span>
                  </td>
                  <td><?php echo e($origin->created_at); ?></td>
                  <td class="actions">
                     <a href="<?php echo e(route('admin.origin_edit', $origin->id)); ?>"><i class="edit fa fa-pencil"></i></a>
                     <a href="<?php echo e(route('admin.origin_delete', $origin->id)); ?>"><i class="edit fa fa-trash"></i></a>
                  </td>
               </tr>
               <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
         </table>
         <?php else: ?>
         <p>No Origins</p>
         <?php endif; ?>
      </div>
   </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_css'); ?>
    <style>
      tr.product-table td {
         color: black;
         text-transform: none!important;
      }
      span.badge.bg-success {
         padding: 4px 5px;
         border-radius: 6px!important;
      }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra_body'); ?>
<script>
   // $(document).ready(() => {
   //   $('.remove_product').on('click', function(e) {
   //     e.preventDefault()
   //     var confirmA = confirm('Delete The Origin ?')
   //     var product_id = $(this).attr('data-id')
   //     var link = "{{}}"
   //     if(confirmA) {
   //       window.location.href = link.replace('/0', '/'+product_id)
   //     }
   //   });
   // })
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.adminapp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/ultrasubiv.co.uk/resources/views/admin/origins.blade.php ENDPATH**/ ?>